/*
 * AgentPacketReader.java	97/10/05
 * 
 * Copyright (c) 1997 Ichiro Satoh All Rights Reserved.
 * 
 */
package agentspace;

import java.io.*;
import java.net.*;
import java.lang.*;

public class AgentPacketReader {
  byte[] head = new byte[4];
  DataInputStream dis;
  public AgentPacketReader(byte[] data) {
    ByteArrayInputStream bais = new ByteArrayInputStream(data);
    dis = new DataInputStream(bais);
    try {
      head[0] = dis.readByte();
      head[1] = dis.readByte();
      head[2] = dis.readByte();
    }
    catch (IOException e) { 	 
	System.err.println(e); 	 
    } 
  }
  public boolean isAgent() {
    if (head[0] == 'A' && head[1] == 'C' && head[2] == 'E') {
      return true;
    }
    return false;
  }
  public boolean isMessage() {
    if (head[0] == 'M' && head[1] == 'S' && head[2] == 'G') {
      return true;
    }
    return false;
  }
  public AgentInfo getAgentData() {
    AgentInputStream ais = new AgentInputStream(dis);
    return ais.read();
  }
}
