package agentspace;

import java.util.Vector;

public class AgentQueue extends Vector {

  public synchronized Object put(Object item) {
    addElement(item);
    if (size() == 1){
      notifyAll();
    }
    return item;
  }
  
  public synchronized Object push(Object item) {
    insertElementAt(item, 0);
    if (size() == 1){
      notifyAll();
    }
    return item;
  }
  
  public synchronized Object get() {
    Object  item;
    while (size() <= 0){
      try {
	wait();
      }
      catch (InterruptedException e) {}
    }
    item = elementAt(0);
    removeElementAt(0);
    return item;
  }
  
  public synchronized void remove(Object item) {
    removeElement(item);
  }
  
  public synchronized Object show(int i) {
    if (0 < i && i < size() ) {
      return elementAt(i);
    }
    return null;
  }
  
  public boolean empty() {
    return size() == 0;
  }

  public int search(Object item) {
    int i = indexOf(item, 0);
    if (i >= 0) {
      return i;
    }
    return -1;
  }
}
