/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;
import java.io.*;
import java.net.*;
import java.lang.*;
import java.util.*;
import java.util.zip.*;

public class AgentReceiver extends Thread {
  private final int MAXRECEIVERTHREADS = 8;
  private ServerSocket socketServer = null;
  private AgentManager theAgentManager;

  public AgentReceiver(AgentManager am) {
    theAgentManager = am;
    try { 
      socketServer = new ServerSocket(AgentServer.theReceivePort);
      for( int i = 0 ; i < MAXRECEIVERTHREADS ; i++ ) {
	Thread newAccepter = new Thread(this);
	newAccepter.start();
      }
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }

  /* The number of the following run()-thread is MAXRECEIVERTHREADS */
  public void run() {
    Socket accepted;
    byte[] data;
    AgentPacketReader apr;
    while(true) {
      accepted = null;
      data = null;
      apr = null;
      try {
	accepted = socketServer.accept();
	data = AgentByteCode.streamToByteArray(accepted.getInputStream());
	apr = new AgentPacketReader(data);
	accepted.close();
	if (apr.isAgent()){
	  theAgentManager.registry(apr.getAgentData());
	}
      }
      catch (Exception e) {
	e.printStackTrace();
      }
    }
  }
}


