/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class AgentSender  extends Thread {
  private int thePortNumber;
  private String theHostName;
  private AgentManager theManager;
  private AgentInfo theAgentInfo;
  private boolean flag;
  public AgentSender(String address, int port, AgentManager am) {
    thePortNumber = port;
    theHostName = address;
    theManager = am;
  }

  public synchronized void transfer(AgentInfo ainfo) {
    theAgentInfo = ainfo;
    Thread newSender = new Thread(this);
    newSender.start();
  }

  public void run() {
    flag = false;
    if (sender()) {
      return;
    }
    else {
      for (int i = 0 ; i < 3 ; i++ ) {
	try{
	  Thread.sleep( 10000 );
	} catch (Exception e) {}
	if (sender()) {
	  return;
	}
      }
      theManager.dispatchFailure(theAgentInfo);
    }
  }

  private synchronized boolean sender() {
    Socket socket = null;
    try {
      socket = new Socket(theHostName, thePortNumber);
      AgentWriteStream aws = 
	new AgentWriteStream(socket.getOutputStream());
      aws.storeAgent(theAgentInfo);
      socket.close();
      theManager.unregistry(theAgentInfo);
      System.gc();
    } catch (IOException e) {
      System.err.println(e);
      if (socket != null) {
	try {
	  socket.close();
	} catch (IOException ee) {}
      }
      return false;
    } 
    return true;
  }
}

