/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.io.*;
import java.util.*;
import java.lang.*;
import java.net.*;

class AgentServer extends Thread {
  public static int theSendPort;
  public static int theReceivePort;
  public static String theSendHost;
  public static String theHost;
  private AgentManager theAgentManager;
  public  AgentMonitor theAgentMonitor;
  private AgentList theAgentList;
  private AgentReceiver theAgentReceiver;
  public boolean bRun = true;
  
  public static void main(String args[] ) {
    if (args.length == 2) {
      try {
	theReceivePort = Integer.parseInt(args[0]); 
	theSendPort    = Integer.parseInt(args[1]); 
      }      
      catch (NumberFormatException e) {
	theSendPort = 5000;
	theReceivePort = 5000;
	theSendPort = theReceivePort;
      }
    }
    else {
      theReceivePort = theSendPort = 5000;
    }
    try {
      theHost = (InetAddress.getLocalHost()).getHostAddress();
      theSendHost = (InetAddress.getLocalHost()).getHostAddress();
    }
    catch (UnknownHostException e) {
      theHost = "133.65.66.200";
    }
    System.out.println("Host Address   = "+theHost);
    System.out.println("Port (send)    = "+theSendPort);
    System.out.println("Port (receive) = "+theReceivePort);
    AgentServer agentServer = new AgentServer();
  }

  public AgentServer() {
    theAgentList = new AgentList();
    theAgentManager = new AgentManager(this, theAgentList);
    theAgentMonitor = new AgentMonitor(theAgentManager, theAgentList);
    theAgentReceiver  = new AgentReceiver(theAgentManager);
  }

  public void quit() {
    System.exit(0);
  }
}


