/*
 * Copyright (C) 1998 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;

import java.lang.*;
import java.lang.reflect.*;
import java.io.*;
import java.net.*;
import java.util.*;

public class AgentTimeout implements Runnable {
  private Message theMessage;
  private boolean finished = false;

  public AgentTimeout() {}

  public void run() {
    if (theMessage != null) {
      if (theMessage.getFuture() != null) {
	theMessage.getFuture().getReply();
      }
      finished = true;
    }
  }

  public void enqueueMessage(Message msg, AgentMessageQueue queue, 
				ThreadGroup tg) {
    int timelimit = msg.getTimeout();
    if (timelimit > 0 && msg.getFuture() != null) {
      theMessage = msg;
      ThreadGroup aThreadGroup = tg;
      finished = false;
      ThreadGroup newThreadGroup = 
	new ThreadGroup(aThreadGroup, "SYSTEM-THREAD-GROUP");
      Thread aThread = new Thread(newThreadGroup, this);
      aThread.start();
      try {
	aThread.join(timelimit);
      }
      catch(InterruptedException e) {}
      if (!(finished)) {
	System.out.println("TIMEOUT: "+theMessage);
	queue.removeMessage(theMessage);
	newThreadGroup.stop();
	aThread.stop();
	theMessage.setException(new TimeoutException());
	theMessage.getFuture().setReply(null);
      }
    }
  }
}
