/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;
import java.lang.*;
import java.io.*;
import java.net.*;
import java.util.*;
import java.util.zip.*;

public class AgentWriteStream {
  DataOutputStream dos;
  public AgentWriteStream(OutputStream os) {
    dos = new DataOutputStream(os);
  }

  public void storeAgent(AgentInfo ainfo) {    
    byte[] data = AgentPacketEncode.makeDataPacket(ainfo);
    byte[] code = AgentPacketEncode.makeCodePacket(ainfo);
    try {
      dos.writeByte('A'); /*  Agent  */
      dos.writeByte('C'); /*  Coordination  */
      dos.writeByte('E'); /*  Environment  */
      dos.writeInt(data.length);
      dos.writeInt(code.length);
      dos.write(data, 0, data.length);
      dos.write(code, 0, code.length);
/*
      System.out.println("code(" + code.length + ") + data("
	 + data.length + ") = " + (code.length+data.length));
*/
      dos.close();
    } catch (IOException e) { 	 
      System.err.println(e); 	 
    } 
  }
}


