package agentspace;
import java.io.*;
import java.net.*;
import java.util.*;
import java.lang.*;
import java.lang.reflect.*;

public class Future implements Serializable {
  private boolean accepted = false;
  private Object theResult = null;
  private Message theMessage = null;

  public Future(){}

  public synchronized void setReply(Object obj) {
//    System.out.println("Future: setReply() started");
    accepted = true;
    theResult = obj;
    notify();
  }

  public synchronized void setMessage(Message msg) {
    theMessage = msg;
  }

  public synchronized Object getReply() {
    while (accepted == false) {
      try{
	wait();
      }
      catch (InterruptedException e) {}
    }
    return theResult;
  }

  public synchronized Object get() throws 
  TimeoutException, InvocationException {
    while (accepted == false) {
      try{
	wait();
      }
      catch (InterruptedException e) {}
    }
    if (theMessage != null) {
      Exception ex = theMessage.getException();
      if (ex != null) {
	if (ex instanceof TimeoutException) {
	  throw new TimeoutException();
	}
	else if (ex instanceof InvocationTargetException) {
	  throw new InvocationException();
	}
	else {
	  throw new InvocationException();
	}
      }
    }
    return theResult;
  }
}
