/*
 * Copyright (C) 1997 Ichiro Satoh
 * All Rights Reserved.
 * written by Ichiro Satoh
 *
 * This program was developed by Ichiro Satoh at Ochanomizu University 
 * as a part of a mobile object system, titled "AgentSpace". All the 
 * programs of the system is developed by Ichiro Satoh and all rights 
 * are reserved by Ichiro Satoh. 
 *
 * Permission to use, copy, modify and distribute this software and
 * its documentation is hereby granted, provided that both the
 * copyright notice and this permission notice appear in all copies of
 * the software, derivative works or modified versions, and any
 * portions thereof, and that both notices appear in supporting 
 * documentation.
 *
 * FREE USE OF THIS SOFTWARE IS ALLOWED IN ITS "AS IS" CONDITION.
 * BUT WITHOUT WARRANTY. THE AUTHORS DISCLAIM ANY LIABILITY OF ANY 
 * KIND FOR ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS 
 * SOFTWARE.
 */

package agentspace;
import java.io.*;
import java.net.*;
import java.lang.*;
import java.util.*;

public class Message implements Serializable {
  private AgentIdentifier theSenderID = null;
  private AgentIdentifier theTargetID = null;
  private String theName = null;
  private Vector argsList;
  private Class theReturnType;
  private Future theFuture = null;
  private URL theSenderURL = null;
  private URL theTargetURL = null;
  private int theTimeLimit = 0;
  private Exception theException = null;

  public Message(String name, AgentIdentifier targetID, String target, 
		 AgentIdentifier senderID) {
    theName = name;
    theTargetID = targetID;
    theSenderID = senderID;
    argsList = new Vector();
  }

  public Message(String msg, AgentIdentifier target) {
    this(msg, target, null, null);
  }

  public Message(String msg, String target) {
    this(msg, null, target, null);
  }

  public Message(String msg) {
    this(msg, null, null, null);
  }

  public Message() {
    this(null, null, null, null);
  }

  public void setArg(Object obj) {
    argsList.addElement(obj);
  }

  public void setArg(Object obj, int loc) {
    argsList.setElementAt(obj, loc);
  }

  public Object getArg(int loc) {
    return argsList.elementAt(loc);
  }

  public int getArgCount() {
    return argsList.size();
  }

  public void setSender(AgentIdentifier senderID) {
    theSenderID = senderID;
  }

  public AgentIdentifier getSender() {
    return theSenderID;
  }

  public void setTarget(AgentIdentifier targetID) {
    theTargetID = targetID;
  }

  public AgentIdentifier getTarget() {
    return theTargetID;
  }

  public void setName(String name) {
    theName = name;
  }

  public String getName() {
    return theName;
  }

  public void setReturnType(Class c) {
    theReturnType = c;
  }

  public Class getReturnType() {
    return theReturnType;
  }

  public void setFuture(Future futureObject) {
    theFuture = futureObject;
  }

  public Future getFuture() {
    return theFuture;
  }

  public void setSenderURL(URL url) {
    theSenderURL = url;
  }

  public URL getSenderURL() {
    return theSenderURL;
  }

  public void setTargetURL(URL url) {
    theTargetURL = url;
  }

  public URL getTargetURL() {
    return theTargetURL;
  }

  public void setTimeout(int timelimit) {
    theTimeLimit = timelimit;
  }

  public int getTimeout() {
    return theTimeLimit;
  }

  public void setException(Exception e) {
    if (theException == null) {
      theException = e;
    }
  }

  public Exception getException() {
    return theException;
  }

  public Message copyTo(Message msg) {
    msg.setName(theName);
    msg.setSender(theSenderID);
    msg.setTarget(theTargetID);
    msg.setReturnType(theReturnType);
    msg.setFuture(theFuture);
    msg.setSenderURL(theSenderURL);
    msg.setTargetURL(theTargetURL);
    for (int i = 0 ; i < argsList.size() ; i++ ) {
      msg.setArg((Object)(argsList.elementAt(i)));
    }
    return msg;
  }

  public void replace(Message msg) {
    theName = msg.getName();
    theSenderID = msg.getSender();
    theTargetID = msg.getTarget();
    theFuture = msg.getFuture();
    theReturnType = msg.getReturnType();
    theSenderURL =  msg.getSenderURL();
    theTargetURL =  msg.getTargetURL();
    argsList = new Vector();
    for (int i = 0 ; i < msg.getArgCount() ; i++) {
      this.setArg(msg.getArg(i));
    }
  }

  public String toString() {
    return getName()+" "+getSender()+" "+getTarget();
  }
/*
  public void writeTo(DataOutput dop) {
    dop.writeLong((new Long(theSenderID)));
    dop.writeLong((new Long(theTargetID)));
    dop.writeUTF(theName);
    dop.writeObject(theFuture);
    dop.writeInt(argsList.size());
    for (int i = 0 ; i < argsList.size() ; i++ ) {
      dop.writeObject(argsList.elementAt(i));
    }
  }

  private void read(DataInput dip) {
    theSenderID = dip.readLong();
    theTargetID = dip.readLong();
    theName = dip.readUTF();
    theFuture = dip.readObject();
    int len = dataInput.readInt();
    for (int i = 0 ; i < len ; i++ ) {
      setArg(i) = dip.readObject();
    }
  }
*/
}
