/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import org.eclipse.ui.PlatformUI;

public class FFMpegUI {
    public static final String FFMPEG_PATH = "ffmpeg.ffmpeg_path";
    public static final String PURE_FFMPEG_PATH = "ffmpeg.pure_ffmpeg_path";
    public static final String USE_PURE_FFMPEG = "ffmpeg.use_pure_ffmpeg";
    public static final String USE_THREAD = "ffmpeg.use_thread";
    public static final String DEMUX_SOME_VIDEO = "ffmpeg.demux_dome_video";

    public static boolean isPureFFMpegSupportedVideoCodec(String codec) {
        String[] supportec = new String[]{"huffyuv", "mjpeg", "mpeg1video", "msmpeg4v1", "msmpeg4v2", "wmv1", "wmv2", "copy"};
        int i = 0;
        while (i < supportec.length) {
            if (codec.equals(supportec[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isPureFFMpegSupportedAudioCodec(String codec) {
        String[] supportec = new String[]{"copy", "mp2", "pcm_s16le", "wmav1", "wmav2"};
        int i = 0;
        while (i < supportec.length) {
            if (codec.equals(supportec[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getFFmpeg() {
        String ffmpeg = PlatformUI.getPreferenceStore().getString(FFMPEG_PATH);
        if (ffmpeg.length() == 0) {
            return null;
        }
        return ffmpeg;
    }

    public static String getPureFFmpeg() {
        String ffmpeg = PlatformUI.getPreferenceStore().getString(PURE_FFMPEG_PATH);
        if (ffmpeg.length() == 0) {
            return null;
        }
        return ffmpeg;
    }

    public static String getFFmpegOrPureFFMpeg() {
        String ret = null;
        String ffmpeg = PlatformUI.getPreferenceStore().getString(FFMPEG_PATH);
        String pure_ffmpeg = PlatformUI.getPreferenceStore().getString(PURE_FFMPEG_PATH);
        if (ffmpeg.length() == 0) {
            ffmpeg = null;
        }
        if (pure_ffmpeg.length() == 0) {
            pure_ffmpeg = null;
        }
        if (pure_ffmpeg == null && ffmpeg != null) {
            ret = ffmpeg;
        }
        if (ffmpeg == null && pure_ffmpeg != null) {
            ret = pure_ffmpeg;
        }
        if (ffmpeg != null && pure_ffmpeg != null) {
            ret = PlatformUI.getPreferenceStore().getBoolean(USE_PURE_FFMPEG) ? pure_ffmpeg : ffmpeg;
        }
        return ret;
    }

    public static boolean isUseThread() {
        return PlatformUI.getPreferenceStore().getBoolean(USE_THREAD);
    }

    public static boolean isFFMpegOrPureFFMpegAvailable(String path) {
        return path != null && !path.equals("") && (path.endsWith("ffmpeg.exe") || path.endsWith("pure_ffmpeg.exe")) && new File(path).exists();
    }

    public static boolean isPureFFMpeg(String path) {
        return path.toLowerCase().endsWith("pure_ffmpeg.exe");
    }
}

