/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import jp.sourceforge.akjrcp.ffmpeg.AdvancedAudioFFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegFLVParser;
import jp.sourceforge.akjrcp.ffmpeg.FFMpegPreference;
import jp.sourceforge.akjrcp.ffmpeg.FLVInfomation;

public class WavFFMpegPreference
extends AdvancedAudioFFMpegPreference {
    public String[] toCommand(String input, String avsInput, String output) {
        FFMpegFLVParser parser = new FFMpegFLVParser(this.getFfmpegPath());
        FLVInfomation info = parser.parseFile(new File(input));
        if (!info.isHaveAudio()) {
            if (avsInput == null) {
                log.warn((Object)"no aduio stream");
                return null;
            }
            info = parser.parseFile(new File(avsInput));
            if (!info.isHaveAudio()) {
                log.warn((Object)"no aduio stream even in avs");
                return null;
            }
        }
        System.out.println("info:" + info.getAudioRate() + "," + info.getAudioChannel());
        if (!this.isForceConvert()) {
            this.setAudioRate(info.getAudioRate());
            this.setAudioChannel(info.getAudioChannel());
        } else {
            if (this.getConvertChannel() == -1) {
                this.setAudioChannel(info.getAudioChannel());
            } else {
                this.setAudioChannel(this.getConvertChannel());
            }
            if (this.getConvertFramerate() == -1) {
                this.setAudioRate(info.getAudioRate());
            } else {
                this.setAudioRate(this.getConvertFramerate());
            }
        }
        int bps = this.getAudioRate() * this.getAudioChannel() * 16 / 1000;
        this.setGuessSize(FFMpegPreference.toKBytes(info.getDuration(), bps));
        System.out.println("info:" + this.getAudioRate() + "," + this.getAudioChannel());
        return super.toCommand(input, avsInput, output);
    }
}

