/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ui;

import jp.sourceforge.akjrcp.ui.AbstractParamItem;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class ParamSpinner
extends AbstractParamItem {
    private String key;
    private String label;
    private Label labelItem;
    private String value = "";
    private Spinner spinner;

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public void setDigits(int digit) {
        this.spinner.setDigits(digit);
    }

    public void setToolTipText(String text) {
        this.labelItem.setToolTipText(text);
        this.spinner.setToolTipText(text);
    }

    public double getDigitedSelection() {
        int base = 1;
        int i = 0;
        while (i < this.spinner.getDigits()) {
            base *= 10;
            ++i;
        }
        return (double)this.spinner.getSelection() / (double)base;
    }

    public String getValue() {
        return "" + this.getDigitedSelection();
    }

    public void setValue(String value) {
        if (value.length() > 0) {
            double dvalue = Double.parseDouble(value);
            this.spinner.setSelection(this.forDigit(dvalue));
        }
        this.value = value;
    }

    public ParamSpinner(Composite parent, int style, String key, String label) {
        super(parent, style);
        this.key = key;
        this.label = label;
        this.setLayout((Layout)new GridLayout(2, false));
        this.labelItem = new Label((Composite)this, 0);
        this.labelItem.setText(label);
        this.spinner = new Spinner((Composite)this, 0);
        this.spinner.addSelectionListener((SelectionListener)new AbstractParamItem.SelectionCheck());
    }

    public boolean isModified() {
        String oldValue = this.getValue();
        return !oldValue.equals(this.value);
    }

    public void setMaximum(double max) {
        this.spinner.setMaximum(this.forDigit(max));
    }

    public void setMinimum(double min) {
        this.spinner.setMinimum(this.forDigit(min));
    }

    private int forDigit(double value) {
        int base = 1;
        int i = 0;
        while (i < this.spinner.getDigits()) {
            base *= 10;
            ++i;
        }
        return (int)(value * (double)base);
    }

    public Spinner getSpinner() {
        return this.spinner;
    }

    public void setSpinner(Spinner spinner) {
        this.spinner = spinner;
    }
}

