/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jp.sourceforge.akjrcp.util.ProcessPrinter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProcessMonitor {
    Log log = LogFactory.getLog(ProcessMonitor.class);
    Process process;
    boolean monitor;
    ProcessPrinter printer;
    private boolean monitorInput = true;
    private boolean monitorError = true;
    private boolean inputClosed;
    private boolean errorClosed;
    InputStream inputStream;
    InputStream errorStream;

    public boolean isErrorClosed() {
        return this.errorClosed;
    }

    public boolean isInputClosed() {
        return this.inputClosed;
    }

    public ProcessMonitor(Process process, ProcessPrinter printer) {
        this.process = process;
        this.printer = printer;
    }

    public void startMonitor() {
        this.monitor = true;
        if (this.monitorError) {
            new ErrorMonitor().start();
        } else {
            this.errorClosed = true;
        }
        if (this.monitorInput) {
            new InputMonitor().start();
        } else {
            this.inputClosed = true;
        }
    }

    public void stop() {
        try {
            this.inputStream.close();
            this.errorStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isMonitorInput() {
        return this.monitorInput;
    }

    public void setMonitorInput(boolean monitorInput) {
        this.monitorInput = monitorInput;
    }

    public boolean isMonitorError() {
        return this.monitorError;
    }

    public void setMonitorError(boolean monitorError) {
        this.monitorError = monitorError;
    }

    public class ErrorMonitor
    extends Thread {
        public void run() {
            ProcessMonitor.this.log.info((Object)"errorMonitor:start");
            if (ProcessMonitor.this.printer == null) {
                ProcessMonitor.this.errorStream = ProcessMonitor.this.process.getErrorStream();
                try {
                    try {
                        while (ProcessMonitor.this.errorStream.read() != -1) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    try {
                        ProcessMonitor.this.errorStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                ProcessMonitor.this.errorStream = ProcessMonitor.this.process.getErrorStream();
                BufferedReader breader = new BufferedReader(new InputStreamReader(ProcessMonitor.this.errorStream));
                StringBuffer buffer = new StringBuffer();
                try {
                    int b;
                    while ((b = breader.read()) != -1) {
                        if ((char)b == '\n') {
                            ProcessMonitor.this.printer.printError(String.valueOf(buffer.toString()) + "\n");
                            buffer = new StringBuffer();
                            continue;
                        }
                        if ((char)b == '\r') {
                            ProcessMonitor.this.printer.printError(String.valueOf(buffer.toString()) + "\n");
                            buffer = new StringBuffer();
                            continue;
                        }
                        buffer.append((char)b);
                    }
                    breader.close();
                    ProcessMonitor.this.errorStream.close();
                    ProcessMonitor.this.errorClosed = true;
                    ProcessMonitor.this.log.info((Object)"error close");
                    if (buffer.length() > 0) {
                        ProcessMonitor.this.printer.printError(String.valueOf(buffer.toString()) + "\n");
                    }
                }
                catch (IOException e) {
                    try {
                        ProcessMonitor.this.errorStream.close();
                        ProcessMonitor.this.inputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    e.printStackTrace();
                }
            }
        }
    }

    public class InputMonitor
    extends Thread {
        public void run() {
            ProcessMonitor.this.log.info((Object)"inputMonitor:start");
            if (ProcessMonitor.this.printer == null) {
                ProcessMonitor.this.inputStream = ProcessMonitor.this.process.getInputStream();
                try {
                    try {
                        while (ProcessMonitor.this.inputStream.read() != -1) {
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                finally {
                    try {
                        ProcessMonitor.this.inputStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                ProcessMonitor.this.inputStream = ProcessMonitor.this.process.getInputStream();
                StringBuffer buffer = new StringBuffer();
                try {
                    int b;
                    while ((b = ProcessMonitor.this.inputStream.read()) != -1) {
                        if ((char)b == '\n') {
                            ProcessMonitor.this.printer.printOutput(String.valueOf(buffer.toString()) + "\n");
                            buffer = new StringBuffer();
                            continue;
                        }
                        if ((char)b == '\r') {
                            ProcessMonitor.this.printer.printOutput(String.valueOf(buffer.toString()) + "\n");
                            buffer = new StringBuffer();
                            continue;
                        }
                        buffer.append((char)b);
                    }
                    ProcessMonitor.this.inputStream.close();
                    ProcessMonitor.this.log.info((Object)"input close");
                    ProcessMonitor.this.inputClosed = true;
                    if (buffer.length() > 0) {
                        ProcessMonitor.this.printer.printOutput(String.valueOf(buffer.toString()) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

