/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.videotools.dvdchapter;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import jp.sourceforge.akjrcp.akj_betas.Akj_betasPlugin;
import jp.sourceforge.akjrcp.videotools.dvdchapter.DVDInfomation;

public class MPlayerDVDParser {
    private String mplayerPath;

    public MPlayerDVDParser(String playerPath) {
        this.mplayerPath = playerPath;
    }

    public DVDInfomation parseDVD(File dvd) {
        System.out.println("parse:");
        String s = this.toDVDTitlesetString(dvd, 1);
        System.out.println(s);
        String c = this.getChapter(s);
        int titleSize = this.countTitleSets(s);
        String[] chapters = new String[titleSize];
        chapters[0] = c;
        int i = 1;
        while (i < titleSize) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String s2 = this.toDVDTitlesetString(dvd, i + 1);
            System.out.println(s2);
            chapters[i] = this.getChapter(s2);
            ++i;
        }
        DVDInfomation dvdinfo = new DVDInfomation(dvd);
        dvdinfo.setChapters(chapters);
        return dvdinfo;
    }

    public String toDVDTitlesetString(File dvd, int titleset) {
        String text = "";
        String[] commands = this.toCommand(dvd, titleset);
        Runtime r = Runtime.getRuntime();
        try {
            String tmp;
            Process process = r.exec(commands);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((tmp = reader.readLine()) != null) {
                Akj_betasPlugin.getDefault().getProcessPrinter().printOutput(tmp);
                if (tmp.startsWith("=")) {
                    process.destroy();
                    break;
                }
                text = String.valueOf(text) + tmp + "\n";
            }
        }
        catch (IOException e) {
            Akj_betasPlugin.getDefault().getProcessPrinter().printError(String.valueOf(e.getMessage()) + "\n");
            e.printStackTrace();
        }
        return text;
    }

    public String getChapter(String data) {
        String chap = "";
        String[] lines = data.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith("CHAPTERS: ")) {
                chap = lines[i].substring("CHAPTERS: ".length());
                if (!chap.endsWith(",")) break;
                chap = chap.substring(0, chap.length() - 1);
                break;
            }
            ++i;
        }
        return chap;
    }

    public int countTitleSets(String data) {
        int r = 0;
        String[] lines = data.split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith("ID_DVD_TITLES=")) {
                r = Integer.parseInt(lines[i].substring("ID_DVD_TITLES=".length()));
                break;
            }
            ++i;
        }
        return r;
    }

    public String[] toCommand(File dvd, int titleset) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.mplayerPath);
        list.add("-identify");
        list.add("-dvd-device");
        list.add(dvd.getAbsolutePath());
        list.add("dvd://" + titleset);
        return list.toArray(new String[list.size()]);
    }
}

