/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.update.core.IFeatureContentConsumer;
import org.eclipse.update.core.IPluginEntry;
import org.eclipse.update.core.PluginEntry;
import org.eclipse.update.internal.core.DeltaInstallHandler;

public class JarDeltaInstallHandler
extends DeltaInstallHandler {
    protected void overlayPlugin(IPluginEntry oldPlugin, IPluginEntry newPlugin, IFeatureContentConsumer consumer) throws CoreException, IOException {
        if (newPlugin instanceof PluginEntry && ((PluginEntry)newPlugin).isUnpack()) {
            super.overlayPlugin(oldPlugin, newPlugin, consumer);
        }
        URL oldURI = null;
        try {
            oldURI = new URL(String.valueOf(consumer.getFeature().getSite().getURL().getPath()) + "plugins/" + oldPlugin.getVersionedIdentifier().toString());
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        File oldJarFile = new File(oldURI.toExternalForm());
        JarFile oldJar = new JarFile(oldJarFile);
        URL newURI = null;
        try {
            newURI = new URL(String.valueOf(consumer.getFeature().getSite().getURL().getPath()) + "plugins/" + newPlugin.getVersionedIdentifier().toString());
        }
        catch (MalformedURLException e) {
            throw new IOException(e.getMessage());
        }
        File newJarFile = new File(newURI.toExternalForm());
        JarFile newJar = new JarFile(newJarFile);
        String tempFileName = oldURI + "-" + new Date().getTime();
        File tempFile = new File(tempFileName);
        FileOutputStream fos = new FileOutputStream(tempFile);
        JarOutputStream jos = new JarOutputStream(fos);
        JarDeltaInstallHandler.addToJar(jos, newJar);
        JarDeltaInstallHandler.addToJar(jos, oldJar);
        jos.closeEntry();
        jos.finish();
        fos.close();
        newJar.close();
        oldJar.close();
        newJarFile = new File(newURI.toExternalForm());
        newJarFile.delete();
        newJarFile.createNewFile();
        JarDeltaInstallHandler.copyFile(tempFile, newJarFile);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyFile(File src, File dst) throws IOException {
        OutputStream out;
        block12: {
            BufferedInputStream in = null;
            out = null;
            try {
                int len;
                in = new BufferedInputStream(new FileInputStream(src));
                out = new BufferedOutputStream(new FileOutputStream(dst));
                byte[] buffer = new byte[4096];
                while ((len = ((InputStream)in).read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                if (out == null) throw throwable;
                try {
                    out.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var6_8 = null;
                if (in == null) break block12;
            }
            try {}
            catch (IOException iOException) {}
            ((InputStream)in).close();
        }
        if (out == null) return;
        try {}
        catch (IOException iOException) {
            return;
        }
        out.close();
    }

    public static void addToJar(JarOutputStream jos, JarFile jf) throws IOException {
        Enumeration<JarEntry> e = jf.entries();
        while (e.hasMoreElements()) {
            ZipEntry je = e.nextElement();
            InputStream io = jf.getInputStream(je);
            byte[] b = new byte[4096];
            int read = 0;
            jos.putNextEntry(je);
            while ((read = io.read(b, 0, 4096)) != -1) {
                jos.write(b, 0, read);
            }
        }
    }
}

