/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.internal.ide.model.WorkingSetAdapterFactory;

public class WorkingSetResourceMapping
extends ResourceMapping {
    private IWorkingSet set;

    public WorkingSetResourceMapping(IWorkingSet workingSet) {
        this.set = workingSet;
    }

    public Object getModelObject() {
        return this.set;
    }

    public String getModelProviderId() {
        return "org.eclipse.core.resources.modelProvider";
    }

    public IProject[] getProjects() {
        HashSet<IProject> result = new HashSet<IProject>();
        ResourceMapping[] mappings = this.getMappings();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping mapping = mappings[i];
            IProject[] projects = mapping.getProjects();
            int j = 0;
            while (j < projects.length) {
                IProject project = projects[j];
                result.add(project);
                ++j;
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        ResourceTraversal[] resourceTraversalArray;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            ResourceMapping[] mappings = this.getMappings();
            monitor.beginTask(null, 100 * mappings.length);
            ArrayList<ResourceTraversal> result = new ArrayList<ResourceTraversal>();
            int i = 0;
            while (i < mappings.length) {
                ResourceMapping mapping = mappings[i];
                result.addAll(Arrays.asList(mapping.getTraversals(context, (IProgressMonitor)new SubProgressMonitor(monitor, 100))));
                ++i;
            }
            resourceTraversalArray = result.toArray(new ResourceTraversal[result.size()]);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return resourceTraversalArray;
    }

    private ResourceMapping[] getMappings() {
        IAdaptable[] elements = this.set.getElements();
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < elements.length) {
            IAdaptable element = elements[i];
            ResourceMapping mapping = WorkingSetAdapterFactory.getContributedResourceMapping(element);
            if (mapping == null) {
                mapping = WorkingSetAdapterFactory.getResourceMapping(element);
            }
            if (mapping != null) {
                result.add(mapping);
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public boolean contains(ResourceMapping mapping) {
        ResourceMapping[] mappings = this.getMappings();
        int i = 0;
        while (i < mappings.length) {
            ResourceMapping childMapping = mappings[i];
            if (childMapping.contains(mapping)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

