/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.navigator;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.DeleteResourceAction;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.views.navigator.CopyAction;
import org.eclipse.ui.views.navigator.IResourceNavigator;
import org.eclipse.ui.views.navigator.PasteAction;
import org.eclipse.ui.views.navigator.ResourceNavigatorActionGroup;
import org.eclipse.ui.views.navigator.ResourceNavigatorMoveAction;
import org.eclipse.ui.views.navigator.ResourceNavigatorRenameAction;
import org.eclipse.ui.views.navigator.ResourceSelectionUtil;

public class RefactorActionGroup
extends ResourceNavigatorActionGroup {
    private Clipboard clipboard;
    private CopyAction copyAction;
    private DeleteResourceAction deleteAction;
    private PasteAction pasteAction;
    private ResourceNavigatorRenameAction renameAction;
    private ResourceNavigatorMoveAction moveAction;
    private TextActionHandler textActionHandler;

    public RefactorActionGroup(IResourceNavigator navigator) {
        super(navigator);
    }

    public void dispose() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean anyResourceSelected = !selection.isEmpty() && ResourceSelectionUtil.allResourcesAreOfType(selection, 7);
        this.copyAction.selectionChanged(selection);
        menu.add((IAction)this.copyAction);
        this.pasteAction.selectionChanged(selection);
        menu.add((IAction)this.pasteAction);
        if (anyResourceSelected) {
            this.deleteAction.selectionChanged(selection);
            menu.add((IAction)this.deleteAction);
            this.moveAction.selectionChanged(selection);
            menu.add((IAction)this.moveAction);
            this.renameAction.selectionChanged(selection);
            menu.add((IAction)this.renameAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
        this.textActionHandler = new TextActionHandler(actionBars);
        this.textActionHandler.setCopyAction((IAction)this.copyAction);
        this.textActionHandler.setPasteAction((IAction)this.pasteAction);
        this.textActionHandler.setDeleteAction((IAction)this.deleteAction);
        this.renameAction.setTextActionHandler(this.textActionHandler);
        actionBars.setGlobalActionHandler(ActionFactory.MOVE.getId(), (IAction)this.moveAction);
        actionBars.setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.renameAction);
    }

    public void handleKeyPressed(KeyEvent event) {
        if (event.character == '\u007f' && event.stateMask == 0) {
            if (this.deleteAction.isEnabled()) {
                this.deleteAction.run();
            }
            event.doit = false;
        } else if (event.keyCode == 0x100000B && event.stateMask == 0) {
            if (this.renameAction.isEnabled()) {
                this.renameAction.run();
            }
            event.doit = false;
        }
    }

    protected void makeActions() {
        TreeViewer treeViewer = this.navigator.getViewer();
        Shell shell = this.navigator.getSite().getShell();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.pasteAction = new PasteAction(shell, this.clipboard);
        ISharedImages images = PlatformUI.getWorkbench().getSharedImages();
        this.pasteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE_DISABLED"));
        this.pasteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_PASTE"));
        this.copyAction = new CopyAction(shell, this.clipboard, this.pasteAction);
        this.copyAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_COPY"));
        this.moveAction = new ResourceNavigatorMoveAction(shell, (StructuredViewer)treeViewer);
        this.renameAction = new ResourceNavigatorRenameAction(shell, treeViewer);
        this.deleteAction = new DeleteResourceAction(shell);
        this.deleteAction.setDisabledImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.deleteAction.setImageDescriptor(images.getImageDescriptor("IMG_TOOL_DELETE"));
    }

    public void updateActionBars() {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        this.copyAction.selectionChanged(selection);
        this.pasteAction.selectionChanged(selection);
        this.deleteAction.selectionChanged(selection);
        this.moveAction.selectionChanged(selection);
        this.renameAction.selectionChanged(selection);
    }
}

