/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.tasklist;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.views.tasklist.TaskListMessages;
import org.eclipse.ui.views.tasklist.MarkerUtil;

public class TaskPropertiesDialog
extends Dialog {
    private static final String DIALOG_SETTINGS_SECTION = "TaskPropertiesDialogSettings";
    private IMarker marker = null;
    private IResource resource = null;
    private Map initialAttributes = null;
    private Text descriptionText;
    private Label creationTime;
    private Combo priorityCombo;
    private Button completedCheckbox;
    private Label severityLabel;
    private Text resourceText;
    private Text folderText;
    private Text locationText;
    private boolean dirty;

    public TaskPropertiesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setMarker(IMarker marker) {
        this.marker = marker;
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    public IResource getResource() {
        return this.resource;
    }

    public void setInitialAttributes(Map initialAttributes) {
        this.initialAttributes = initialAttributes;
    }

    public Map getInitialAttributes() {
        return this.initialAttributes;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.marker == null) {
            newShell.setText(TaskListMessages.TaskProp_newTaskTitle);
        } else {
            String kind = MarkerUtil.getKindText(this.marker);
            newShell.setText(NLS.bind((String)TaskListMessages.TaskProp_propertiesTitle, (Object)kind));
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.ui.task_properties_dialog_context");
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(comp, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.initializeDialogUnits((Control)composite);
        this.createDescriptionArea(composite);
        if (this.marker != null) {
            this.createSeperator(composite);
            this.createCreationTimeArea(composite);
        }
        this.createSeperator(composite);
        if (this.isTask()) {
            this.createPriorityAndStatusArea(composite);
        } else {
            this.createSeverityArea(composite);
        }
        this.createSeperator(composite);
        this.createResourceArea(composite);
        this.updateDialogFromMarker();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createSeperator(Composite parent) {
        Label seperator = new Label(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        seperator.setLayoutData((Object)gridData);
    }

    private void createCreationTimeArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TaskListMessages.TaskProp_creationTime);
        this.creationTime = new Label(parent, 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.isEditable()) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }

    private void createDescriptionArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TaskListMessages.TaskProp_description);
        int style = 2052;
        if (!this.isEditable()) {
            style |= 8;
        }
        this.descriptionText = new Text(parent, style);
        GridData gridData = new GridData(768);
        gridData.widthHint = this.convertHorizontalDLUsToPixels(400);
        this.descriptionText.setLayoutData((Object)gridData);
    }

    private void createPriorityAndStatusArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TaskListMessages.TaskProp_priority);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        this.priorityCombo = new Combo(composite, 8);
        this.priorityCombo.setItems(new String[]{TaskListMessages.TaskList_high, TaskListMessages.TaskList_normal, TaskListMessages.TaskList_low});
        this.priorityCombo.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        this.completedCheckbox = new Button(composite, 32);
        this.completedCheckbox.setText(TaskListMessages.TaskProp_completed);
        GridData gridData = new GridData();
        gridData.horizontalIndent = this.convertHorizontalDLUsToPixels(20);
        this.completedCheckbox.setLayoutData((Object)gridData);
        if (!this.isEditable()) {
            this.priorityCombo.setEnabled(false);
            this.completedCheckbox.setEnabled(false);
        }
    }

    private void createSeverityArea(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TaskListMessages.TaskProp_severity);
        this.severityLabel = new Label(parent, 0);
    }

    private void createResourceArea(Composite parent) {
        IResource resource = this.getResource();
        if (this.marker == null) {
            if (resource == null) {
                return;
            }
            if ((resource.getType() & 7) == 0) {
                return;
            }
        }
        Label resourceLabel = new Label(parent, 0);
        resourceLabel.setText(TaskListMessages.TaskProp_onResource);
        this.resourceText = new Text(parent, 2124);
        GridData gridData = new GridData(768);
        this.resourceText.setLayoutData((Object)gridData);
        Label folderLabel = new Label(parent, 0);
        folderLabel.setText(TaskListMessages.TaskProp_inFolder);
        this.folderText = new Text(parent, 2124);
        gridData = new GridData(768);
        this.folderText.setLayoutData((Object)gridData);
        Label locationLabel = new Label(parent, 0);
        locationLabel.setText(TaskListMessages.TaskProp_location);
        this.locationText = new Text(parent, 2124);
        gridData = new GridData(768);
        this.locationText.setLayoutData((Object)gridData);
    }

    private void updateDialogFromMarker() {
        if (this.marker == null) {
            this.updateDialogForNewMarker();
            return;
        }
        this.descriptionText.setText(MarkerUtil.getMessage(this.marker));
        this.descriptionText.selectAll();
        this.creationTime.setText(MarkerUtil.getCreationTime(this.marker));
        if (this.isTask()) {
            this.priorityCombo.clearSelection();
            this.priorityCombo.select(2 - MarkerUtil.getPriority(this.marker));
            this.completedCheckbox.setSelection(MarkerUtil.isComplete(this.marker));
            this.markDirty();
        } else {
            String sev = "";
            switch (MarkerUtil.getSeverity(this.marker)) {
                case 2: {
                    sev = TaskListMessages.TaskList_error;
                    break;
                }
                case 1: {
                    sev = TaskListMessages.TaskList_warning;
                    break;
                }
                case 0: {
                    sev = TaskListMessages.TaskList_info;
                }
            }
            this.severityLabel.setText(sev);
        }
        this.resourceText.setText(MarkerUtil.getResourceName(this.marker));
        this.folderText.setText(MarkerUtil.getContainerName(this.marker));
        this.locationText.setText(MarkerUtil.getLineAndLocation(this.marker));
    }

    private void updateDialogForNewMarker() {
        Object o;
        int val;
        Object o2;
        Object o3;
        Map attrs = this.getInitialAttributes();
        String desc = "";
        if (attrs != null && (o3 = attrs.get("message")) instanceof String) {
            desc = (String)o3;
        }
        this.descriptionText.setText(desc);
        this.descriptionText.selectAll();
        int pri = 1;
        if (attrs != null && (o2 = attrs.get("priority")) instanceof Integer && (val = ((Integer)o2).intValue()) >= 0 && val <= 2) {
            pri = val;
        }
        this.priorityCombo.deselectAll();
        this.priorityCombo.select(2 - pri);
        boolean completed = false;
        if (attrs != null && (o = attrs.get("done")) instanceof Boolean) {
            completed = (Boolean)o;
        }
        this.completedCheckbox.setSelection(completed);
        IResource resource = this.getResource();
        if (resource != null && this.resourceText != null) {
            this.resourceText.setText(resource.getName());
            IContainer parent = resource.getParent();
            this.folderText.setText(parent == null ? "" : parent.getFullPath().toString().substring(1));
        }
        int line = -1;
        String loc = "";
        if (attrs != null) {
            Object o4 = attrs.get("lineNumber");
            if (o4 instanceof Integer) {
                line = (Integer)o4;
            }
            if ((o4 = attrs.get("location")) instanceof String) {
                loc = (String)o4;
            }
        }
        if (this.locationText != null) {
            this.locationText.setText(MarkerUtil.getLineAndLocation(line, loc));
        }
        this.markDirty();
    }

    protected void okPressed() {
        this.saveChanges();
        super.okPressed();
    }

    private void markDirty() {
        this.dirty = true;
    }

    private boolean isDirty() {
        return this.dirty;
    }

    private boolean isEditable() {
        return this.marker == null || MarkerUtil.isEditable(this.marker);
    }

    private boolean isTask() {
        return this.marker == null || MarkerUtil.isMarkerType(this.marker, "org.eclipse.core.resources.taskmarker");
    }

    private void saveChanges() {
        if (!this.isEditable() || !this.isDirty()) {
            return;
        }
        final CoreException[] coreExceptions = new CoreException[1];
        final Map attrs = this.getMarkerAttributesFromDialog();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(this, attrs){
                            final /* synthetic */ 2 this$1;
                            private final /* synthetic */ Map val$attrs;
                            {
                                this.this$1 = var1_1;
                                this.val$attrs = map;
                            }

                            public void run(IProgressMonitor monitor) throws CoreException {
                                TaskPropertiesDialog.access$0(2.access$0(this.this$1), monitor, this.val$attrs);
                            }
                        };
                        ResourcesPlugin.getWorkspace().run(runnable, monitor);
                    }
                    catch (CoreException e) {
                        coreExceptions[0] = e;
                    }
                }

                static /* synthetic */ TaskPropertiesDialog access$0(2 var0) {
                    return var0.TaskPropertiesDialog.this;
                }
            });
        }
        catch (InvocationTargetException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            return;
        }
        catch (InterruptedException e) {
            IDEWorkbenchPlugin.log(e.getMessage(), StatusUtil.newStatus(4, e.getMessage(), (Throwable)e));
            return;
        }
        if (coreExceptions[0] != null) {
            ErrorDialog.openError((Shell)this.getShell(), (String)TaskListMessages.TaskProp_errorMessage, null, (IStatus)coreExceptions[0].getStatus());
        }
    }

    private void createOrUpdateMarker(IProgressMonitor monitor, Map attrs) throws CoreException {
        monitor.beginTask(TaskListMessages.TaskPropertiesDialog_WorkingOnMarker, 100);
        if (this.marker == null) {
            monitor.subTask(TaskListMessages.TaskPropertiesDialog_CreatingMarker);
            IResource resource = this.getResource();
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            monitor.worked(25);
            this.marker = resource.createMarker("org.eclipse.core.resources.taskmarker");
            Map initialAttrs = this.getInitialAttributes();
            if (initialAttrs != null) {
                this.marker.setAttributes(initialAttrs);
            }
            monitor.worked(25);
        } else {
            monitor.worked(50);
        }
        monitor.subTask(TaskListMessages.TaskPropertiesDialog_UpdatingAttributes);
        int increment = 50 / attrs.keySet().size();
        Iterator i = attrs.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            Object val = attrs.get(key);
            this.marker.setAttribute(key, val);
            monitor.worked(increment);
        }
        monitor.done();
    }

    private Map getMarkerAttributesFromDialog() {
        HashMap<String, Object> attribs = new HashMap<String, Object>(11);
        if (this.isTask()) {
            attribs.put("message", this.descriptionText.getText());
            int i = this.priorityCombo.getSelectionIndex();
            if (i != -1) {
                attribs.put("priority", new Integer(2 - i));
            }
            attribs.put("done", this.completedCheckbox.getSelection() ? Boolean.TRUE : Boolean.FALSE);
        }
        return attribs;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings settings = IDEWorkbenchPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_SECTION);
        if (section == null) {
            section = settings.addNewSection(DIALOG_SETTINGS_SECTION);
        }
        return section;
    }

    static /* synthetic */ void access$0(TaskPropertiesDialog taskPropertiesDialog, IProgressMonitor iProgressMonitor, Map map) throws CoreException {
        taskPropertiesDialog.createOrUpdateMarker(iProgressMonitor, map);
    }
}

