/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.menus.IWidget;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.WindowTrimProxy;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.IWindowTrim;
import org.eclipse.ui.internal.layout.TrimLayout;
import org.eclipse.ui.internal.menus.ILayoutNode;
import org.eclipse.ui.internal.menus.IMenuService;
import org.eclipse.ui.internal.menus.MenuElement;
import org.eclipse.ui.internal.menus.SGroup;
import org.eclipse.ui.internal.menus.SLayout;
import org.eclipse.ui.internal.menus.SLocation;
import org.eclipse.ui.internal.menus.SMenuLayout;
import org.eclipse.ui.internal.menus.SOrder;
import org.eclipse.ui.internal.menus.SWidget;
import org.eclipse.ui.internal.menus.WidgetProxy;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.menus.IWorkbenchWidget;

public class TrimBarManager {
    private STrimBuilder fTrimBuilder;
    private IMenuService fMenuService;
    private boolean fDirty;
    static /* synthetic */ Class class$0;

    public TrimBarManager(WorkbenchWindow window) {
        if (window == null) {
            throw new IllegalArgumentException("The window cannot be null");
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.menus.IMenuService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fMenuService = (IMenuService)window.getService(clazz);
        this.fTrimBuilder = new STrimBuilder(window);
        this.fDirty = true;
    }

    public void update(boolean force, boolean recursive, boolean hideTopTrim) {
        if (force || this.isDirty()) {
            SMenuLayout layout = this.fMenuService.getLayout();
            this.fTrimBuilder.build(layout, hideTopTrim);
            this.setDirty(false);
        }
    }

    public void update(boolean force, boolean recursive) {
        this.update(force, recursive, false);
    }

    private void setDirty(boolean isDirty) {
        this.fDirty = isDirty;
    }

    private boolean isDirty() {
        return this.fDirty;
    }

    public void updateLocations(List knownIds) {
        this.fTrimBuilder.updateLocations(knownIds);
    }

    public void dispose() {
        this.fMenuService = null;
        this.fTrimBuilder = null;
    }

    private class TrimWidgetProxy
    extends WindowTrimProxy {
        private List widgets;
        private int curSide;
        private Composite parent;
        private SGroup group;

        public TrimWidgetProxy(List widgets, int side, Composite parent, SGroup group, int validSides, boolean resizeable) {
            super((Control)parent, group.getId(), group.getId(), validSides, resizeable);
            this.widgets = widgets;
            this.curSide = side;
            this.parent = parent;
            this.group = group;
        }

        public void dock(int newSide) {
            IWidget widget;
            Iterator iter = this.widgets.iterator();
            while (iter.hasNext()) {
                widget = (IWidget)iter.next();
                widget.dispose();
            }
            iter = this.widgets.iterator();
            while (iter.hasNext()) {
                widget = (WidgetProxy)iter.next();
                widget.fill(this.parent, this.curSide, newSide);
            }
            this.curSide = newSide;
            this.parent.layout();
        }

        public SGroup getGroup() {
            return this.group;
        }

        public void dispose() {
            Iterator iter = this.widgets.iterator();
            while (iter.hasNext()) {
                IWidget widget = (IWidget)iter.next();
                widget.dispose();
            }
            this.getControl().dispose();
        }
    }

    private class STrimBuilder {
        private WorkbenchWindow fWindow;
        private Set bogusTrim = new HashSet();
        private List curGroups = new ArrayList();
        private Map initializedTrim = new HashMap();

        public STrimBuilder(WorkbenchWindow window) {
            this.fWindow = window;
        }

        public void tearDown() {
            Iterator iter = this.curGroups.iterator();
            while (iter.hasNext()) {
                TrimWidgetProxy proxy = (TrimWidgetProxy)iter.next();
                this.fWindow.getTrimManager().removeTrim(proxy);
                proxy.dispose();
            }
            this.curGroups.clear();
        }

        public void build(SMenuLayout layout, boolean hideTopTrim) {
            this.tearDown();
            ILayoutNode trimInfo = layout.getBar("trim");
            List kids = trimInfo.getChildrenSorted();
            Iterator iter = kids.iterator();
            while (iter.hasNext()) {
                ILayoutNode node = (ILayoutNode)iter.next();
                MenuElement element = node.getMenuElement();
                if (element instanceof SWidget || !(element instanceof SGroup)) continue;
                this.renderGroup(node, hideTopTrim);
            }
        }

        private void renderGroup(ILayoutNode groupNode, boolean hideTopTrim) {
            List kids;
            SGroup group = (SGroup)groupNode.getMenuElement();
            if ("testGroup".equals(group.getId())) {
                int i = 0;
                ++i;
            }
            if ((kids = groupNode.getChildrenSorted()).size() == 0) {
                return;
            }
            int side = this.getSide(group);
            if (hideTopTrim && side == 128) {
                return;
            }
            Composite grpComposite = new Composite((Composite)this.fWindow.getShell(), 0);
            grpComposite.setToolTipText(group.getId());
            RowLayout rl = new RowLayout();
            rl.marginWidth = 0;
            rl.marginTop = 0;
            rl.marginRight = 0;
            rl.marginLeft = 0;
            rl.marginHeight = 0;
            rl.marginBottom = 0;
            grpComposite.setLayout((Layout)rl);
            boolean resizeable = false;
            ArrayList<IWidget> groupWidgets = new ArrayList<IWidget>();
            Iterator iter = kids.iterator();
            while (iter.hasNext()) {
                ILayoutNode node = (ILayoutNode)iter.next();
                MenuElement element = node.getMenuElement();
                if (element instanceof SWidget) {
                    SWidget sWidget = (SWidget)element;
                    resizeable = resizeable || this.isResizeable(sWidget);
                    IWidget iw = this.renderTrim(grpComposite, sWidget, side);
                    if (iw == null) continue;
                    groupWidgets.add(iw);
                    continue;
                }
                boolean cfr_ignored_0 = element instanceof SGroup;
            }
            TrimWidgetProxy groupTrimProxy = new TrimWidgetProxy(groupWidgets, side, grpComposite, group, 148608, resizeable);
            this.curGroups.add(groupTrimProxy);
            this.placeGroup(groupTrimProxy);
        }

        private void placeGroup(TrimWidgetProxy proxy) {
            List trim;
            int side = this.getSide(proxy.getGroup());
            boolean atStart = this.isAtStart(proxy.getGroup());
            IWindowTrim beforeMe = null;
            if (atStart && (trim = this.fWindow.getTrimManager().getAreaTrim(side)).size() > 0) {
                beforeMe = (IWindowTrim)trim.get(0);
            }
            try {
                proxy.dock(side);
                TrimLayout tl = (TrimLayout)this.fWindow.getShell().getLayout();
                tl.addTrim(side, proxy, beforeMe);
            }
            catch (Throwable e) {
                IStatus status = null;
                status = e instanceof CoreException ? ((CoreException)e).getStatus() : StatusUtil.newStatus(4, "Internal plug-in widget delegate error on dock.", e);
                WorkbenchPlugin.log("widget delegate failed on dock: id = " + proxy.getId(), status);
            }
        }

        private IWidget renderTrim(Composite groupComposite, SWidget widget, int side) {
            if (this.bogusTrim.contains((Object)widget)) {
                return null;
            }
            IWidget iw = null;
            try {
                iw = widget.getWidget();
                if (iw != null) {
                    if (iw instanceof IWorkbenchWidget && this.initializedTrim.get(iw) == null) {
                        IWorkbenchWidget iww = (IWorkbenchWidget)iw;
                        iww.init(this.fWindow);
                        this.initializedTrim.put(iw, iw);
                    }
                    if (iw instanceof WidgetProxy) {
                        ((WidgetProxy)iw).fill(groupComposite, -1, side);
                    } else {
                        iw.fill(groupComposite);
                    }
                }
            }
            catch (Throwable e) {
                this.bogusTrim.add(widget);
                IStatus status = null;
                status = e instanceof CoreException ? ((CoreException)e).getStatus() : StatusUtil.newStatus(4, "Internal plug-in widget delegate error on creation.", e);
                WorkbenchPlugin.log("Could not create widget delegate for id: " + widget.getId(), status);
                return null;
            }
            return iw;
        }

        private boolean isResizeable(SWidget widget) {
            try {
                SLayout layout = widget.getLayout();
                return layout.fillMajor();
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
                return false;
            }
        }

        private int getSide(SGroup group) {
            int side = 1024;
            try {
                SLocation[] locs = group.getLocations();
                if (locs.length == 0) {
                    return side;
                }
                SOrder order = locs[0].getOrdering();
                String relTo = order.getRelativeTo();
                if ("command1".equals(relTo)) {
                    side = 128;
                } else if ("command2".equals(relTo)) {
                    side = 128;
                } else if ("vertical1".equals(relTo)) {
                    side = 16384;
                } else if ("vertical2".equals(relTo)) {
                    side = 131072;
                } else if ("status".equals(relTo)) {
                    side = 1024;
                }
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
            }
            return side;
        }

        private boolean isAtStart(SGroup group) {
            boolean atStart = false;
            try {
                SLocation[] locs = group.getLocations();
                if (locs.length == 0) {
                    return atStart;
                }
                SOrder order = locs[0].getOrdering();
                atStart = 2 == order.getPosition();
            }
            catch (NotDefinedException e) {
                e.printStackTrace();
            }
            return atStart;
        }

        public void updateLocations(List knownIds) {
            Iterator iter = this.curGroups.iterator();
            while (iter.hasNext()) {
                TrimWidgetProxy proxy = (TrimWidgetProxy)iter.next();
                if (knownIds.contains(proxy.getGroup().getId())) continue;
                this.placeGroup(proxy);
            }
        }
    }
}

