package net.java.amateras.xlsbeans.processor;

import java.lang.reflect.Method;
import java.util.List;

import net.java.amateras.xlsbeans.Utils;
import net.java.amateras.xlsbeans.XLSBeansException;
import net.java.amateras.xlsbeans.annotation.Column;
import net.java.amateras.xlsbeans.xml.AnnotationReader;

/**
 * Provides generic utility methods for {@link HorizontalRecordsProcessor} and 
 * {@link VerticalRecordsProcessor}.
 * 
 * @author Naoki Takezoe
 */
public class RecordsProcessorUtil {
	
	public static void checkColumns(Class<?> recordClass, 
			List<HeaderInfo> headers, AnnotationReader reader) throws Exception {
		for(Method method: Utils.getColumnMethod(recordClass.newInstance(), null, reader)){
			Column column = reader.getAnnotation(recordClass, method, Column.class);
			if(!column.optional()){
				String columnName = column.columnName();
				boolean find = false;
				for(HeaderInfo info: headers){
					if(info.getHeaderLabel().equals(columnName)){
						find = true;
						break;
					}
				}
				if(!find){
					throw new XLSBeansException("Column '" + columnName + "' doesn't exist.");
				}
			}
		}
	}
	
}
