require 'phi'

form = Phi::Form.new
grid = Phi::StringGrid.new form, :grid
button = Phi::Button.new form, :button, "click to clear odd cols"

grid.col_count = 10

(1..4).each do |row|
  (1..10).each do |col|
    grid.cells[col, row] = (col*row).to_s
  end
end

form.client_width = grid.width # B

button.align = Phi::AL_BOTTOM
grid.align = Phi::AL_CLIENT

button.on_click = proc do
  (1..10).each {|col| grid.cols[col].clear if col%2 == 1 }
end

form.show
Phi.mainloop
