#!ruby -Ks

    ##
    ##  xbase.rb
    ##
    ##  supporting library for conversion from xBASE to Apollo.
    ##
    ##  xBase ̈ڐAƂĎx郉CuB
    ##

require "phi"

module Phi

    ##
    ##  get p Edit NX
    ##
    ##  ۑ̃f[^B
    ##  ύXΕۑɕۑB
    ##  t̏iۑɕύXƂɕ\ςj
    ##  ł͏oȂBHHB
    ##
##  class EditXB < Edit
  class EditXB < MaskEdit
    attr :hash,  true
    attr :key,   true
    attr :dirty, true

    def initialize( *args )
      self.on_change = proc {
        if @hash[@key].to_s != self.text
          @hash[@key] = self.text
          @dirty = true
        end
      }
    end

    def reload
      self.text = @hash[@key].to_s
      @dirty = false
    end
  end

  class FormXB < Phi::Form  ## form for xbase conversion
    attr :cell_height
    attr :cell_width
    attr :default_top
    attr :default_left
    attr :prev_label    ##  get  prev_label  focus_control ZbgB
    attr :labels
    attr :edits         ##  [edit:EditXB]

        ##
        ##  tH[̑傫ɂ͎ȂB
        ##  WOQTɂꍇɂ for_xbase gB
        ##  FormXB.new.for_xbase
        ##
        ##  Oł font.name ͉w肷̂ȁHB
        ##
    def initialize( *args )
      self.font.name = "lr "
      self.load_cell_size
      @default_top  = 0     ##  pixelPʁB
      @default_left = 0     ##  pixelPʁB
      @labels = []          ##  ȂłXgɂΏȂB
      @edits  = []
    end

    def load_cell_size
      size = self.canvas.text_extent("W")
      @cell_height = size.cy += 4
      @cell_width  = size.cx += 2
      return size
    end

    def at(row,col=0, *args)
      load_cell_size
      @default_top  = @cell_height * row
      @default_left = @cell_width  * col
      if args != []
        say( *args )
      end
    end

    def say( *args )
      msg = args.shift
      label = Label.new( self )
      label.caption = msg
      label.top  = @default_top
      label.left = @default_left
      @default_left += label.width
      @labels.push( label )
      @prev_label = label
      if args != []
        get( *args )
      end
    end

        ##
        ##  Form#get
        ##
        ##  Hash ^̕ϐ̕\AҏWsB
        ##
        ##  O say ō쐬 Label  focus_control ZbĝŁA
        ##  say "O(&N)" ; get hash, "NAME"
        ##  ̂悤ɃV[gJbgw肷ƁA
        ##  V[gJbgiALT+NjŕҏWANeBuɂȂB
        ##
        ##  쐬 edit Ԃ̂ŁAƎ̃CxgnhȂǂݒ\B
        ##
        ##  Hash ^Ƃ̂ obj[key]Aobj[key]= \bh΂悢B
        ##
        ##  DataSet ł܂ȂBDataSet[FieldName]= B
        ##
        ##  dataset = Table.new( "TableName" ).open
        ##  form.at(10,5) ; form.get( dataset , "FieldName" )
        ##
        ##  ADataSet ڂł͈ɂ̂
        ##  DataSet#mem_store ŃnbVϐɃRs[̂
        ##  ĝ]܂B
        ##
        ##  dataset = Table.new( "TableName" ).open
        ##  mem = dataset.mem_store
        ##  form.at(10,5) ; form.get( mem , "FIELDNAME" )
        ##
        ##  Form ̃\bh̒ł́uform.v͕svɂȂ̂
        ##  ̂悤ɁAقƂ dBASE ɏƂłB
        ##
        ##  ydBASE z
        ## @   04,00   say "YourRef = "   get        YourRefNo
        ##  yFormXBz
        ## at   4,00 ; say "YourRef = " ; get @mem, "YOURREFNO"
        ##
        ##  ܂́Aat()Asay() ͈ get R[̂ŁA
        ## at   4,00 ,     "YourRef = " ,     @mem, "YOURREFNO"
        ##
    def get( hash, key, mask=nil, length=nil )
      if mask.is_a? Integer
        length = mask 
        mask  = nil
      end
      edit = EditXB.new( self )
      edit.hash = hash
      edit.key  = key
      edit.top  = @default_top
      edit.left = @default_left
      edit.text = hash[key].to_s
      edit.auto_size = false
      edit.height = @cell_height
      if mask
        edit.edit_mask = mask 
        length = edit.max_length+1
      end
      edit.width = length * @cell_width if length

      @default_left += edit.width
      @edits.push( edit )

      @prev_label.focus_control = edit if @prev_label
      @prev_label = nil
      return edit
    end

        ##
        ##  get ̃f[^ǂݒB
        ##
    def get_reload
      @edits.each{ |edit| edit.reload }
      self
    end

        ##
        ##  ύX̂ŏ Edit ԂB
        ##
    def get_dirty_edit
      @edits.each{|edit| return edit if edit.dirty }
      return nil
    end

        ##
        ##  get ̃f[^𖳌ɂB
        ##
        ##  p͂ł̃JiHB
        ##  hide Ă΂̂B
        ##
        ##  controls 狭rꍇǂȂ邩HB
        ##  puts form.controls
        ##  Ă݂Ă當B
        ##
    def get_clear
      @labels.each{|label|
        label.visible = false
        controls.delete( label )
      }
      @edits.each{|edit|
        edit.visible = false
        controls.delete( edit )
      }
      @labels = []
      @edits  = []
      self
    end

    def for_xbase( cols=80, lines=25 )
      self.client_width  = self.cell_width  * cols
      self.client_height = self.cell_height * lines
      self
    end
  end

##  class Component
##
##        ##
##        ##  designate position based on charactors.
##        ##
##        ##  Pʂł̈ʒuw
##        ##
##        ##  @ 17,0 say "message:" get variable
##        ##
##        ##  Label.new(form, :l01 , "message:" )   .at(17,0)
##        ##  Edit .new(form, :e01 , variable.to_s ).at(17,10)
##        ##
##        ##  c:\apollo\doc\phi\canvas.pi
##        ##
##    def at(row,col=0)
##      size = parent.canvas.text_extent("W")
##      self.left = col * size.cx
##      self.top  = row * size.cy
##      self
##    end
##  end

end

module RDB
  module DataSet_ex

    ##
    ##  DBXL ̃ϐɋ߂B
    ##
    ##  mem_store Ńf[^ZbgnbVɃRs[B
    ##  mem_replace ŃnbVf[^ZbgɃRs[B
    ##
    ##  ʏ͓ Hash ł @mem gp邪A
    ##  Ŏw肷ΊÕnbVgp悤ɂȂB
    ##  OnbVw肵ꍇɂ͓nbV͕ύXȂB
    ##
    ##  mem_storeAmem_replace ƂɃRs[̃nbVԂB
    ##  mem = dataset.mem_store
    ##  ƂĂ΁AANZXȒPɂȂB
    ##
    ##  mem_replace sOɂ DataSet#edit ȂǂKvB
    ##
    ##  Hash ̃L[͑啶Eʂ̂ŒӁB
    ##  uS啶vɂȂ͗lB
    ##
    ##  mem_store ̓nbVNABNAȂ́A~H
    ##
    ##
    attr :mem
    def initialize( *args )
      @mem = {}
    end
    def mem_store( mem = @mem )
      mem.clear
      fields.each{|f| mem[f.field_name] = f.value }
      mem
    end
    def mem_replace( mem = @mem )
      fields.each{|f| f.value = mem[f.field_name] }
      mem
    end

  end
end

if $0 == __FILE__

  form = Phi::FormXB.new.for_xbase
  form.position = Phi::PO_SCREEN_CENTER

  hash = {}
  hash["key1"] = "test_value(1)"
  hash["key2"] = "test_value(2)"
  hash["key3"] = "test_value(3)"

  button = Phi::Button.new form , :button , "get_clear"
  button.on_click = proc{ form.get_clear }

    ##  ȋLq@
  form.at(13,00) ; form.say(' test1(&A) ') ; form.get( hash , "key1" )

    ##  Lq@iat+say+get xɏj
  form.at(14,00 ,           ' test2(&B) ' ,            hash , "key2" ,16)
  form.say(                 ' test3(&C) ' ,            hash , "key3" , "cc")

  form.on_click = proc { p hash }

  form.show
  Phi.mainloop

end
