$orig_stdin = $stdin
$orig_stdout = $stdout
$orig_stderr = $stderr
$orig_defout = $>

$:.push File.dirname(File.expand_path(__FILE__))

require 'phi'
require 'dialogs'
Phi.export 'Apollo'

fb = Apollo::FORM_BROWSER
fc = Apollo::FORM_CONSOLE
sc = Phi::SCREEN

fb.caption = 'Apollo - ' << Phi::VERSION
#fb.memo1.font.size += 3
fb.width = sc.width - fb.left*3 - fc.width
fb.height = sc.height - fb.top*3 - fc.height

#fc.memo1.font.color = Phi::CL_GREEN
#fc.memo1.word_wrap = true
fc.top = fb.top
fc.left = fb.left + fb.width
fc.height = fb.height
fc.memo1.scroll_bars = Phi::SS_BOTH

fb.on_resize = proc do
  p1 = fb.panel1
  b0 = p1.btn_exec
  b1 = p1.btn_open
  e0 = p1.edit_path
  b0.left = fb.client_width - b0.width - 8
  b1.left = b0.left - b1.width - 8
  d = fb.width - fb.client_width
  e0.width = b1.left - 8 - 8 - d/2
end
fc.on_resize = proc do
  p1 = fc.panel1
  b0 = p1.btn_clear
  b0.left = fc.client_width - b0.width - 8
end

print <<EOT
Apollo console with Phi library  version #{Phi::VERSION}
Phi::PLATFORM=#{Phi::PLATFORM}, Phi::COMPOLIB=#{Phi::COMPOLIB}
ruby #{RUBY_VERSION} (#{RUBY_RELEASE_DATE}) [#{RUBY_PLATFORM}]
control_tree.rb shows controls of Apollo.exe itself.
EOT
load 'control_tree.rb'

#fc.show
#fb.show

#Phi.debug = true
