#! ruby -Ks
require 'phi'
require "rdb"

module Phi
  class Point
    def to_ary
      [x,y]
    end
  end
end

form = Phi::Form.new
@grid = RDB::DBGrid.new form
@grid.align = Phi::AL_CLIENT

def grid_on_dbl_click
  screen_pos = Phi.get_cursor_pos
  grid_pos   = @grid.screen_to_client(screen_pos)
  x,y        = grid_pos  # 
  col,row = @grid.mouse_coord(x,y)
  if row == 0
    p "^Cg̕NbN܂"
  elsif col == 0
    p "[̕NbN܂"
  else
    p "\̕NbN܂"
  end
end

@grid.on_dbl_click = proc{ grid_on_dbl_click}

form.show
Phi.mainloop
