#! ruby -Ks
# by KUMAGAI Hidetake (ggb03124@nifty.ne.jp)
# modified by YOSHIDA Kazuhiro (moriq@moriq.com)
#
#-- $(apollo)/lib/rdb/rdb.rb
#-- rdb.pi
#

require 'phi'
require 'rdb/rdb'
require 'rdb/ado.so'
require 'com'

unless $NO_PHI_EXTENSION
module Phi

class Parameters    ; include Phi::Enumerable ; end

######## class ADOConnection ########

    ##
    ##  ADOTable
    ##  ADOQuery
    ##  ADODataSet
    ##
class ADOConnection
  STD_TABLE_CLASS = ADOTable
  STD_QUERY_CLASS = ADOQuery
  include Connection_ex

  def new_query(sql=nil,params=nil)
    ret = STD_QUERY_CLASS.new
    ret.connection = self
    if sql
      ret.sql_text = sql
      ret.open
    end
    return ret
  rescue
    Phi.add_sql_to_error_message( sql , params )
    raise
  end

  def new_table(name=nil)
    ret = STD_TABLE_CLASS.new
    ret.connection = self
    if name
      ret.table_name = name
      ret.open
    end
    return ret
  end

  def table_exist?(table_name)
    nm = table_name.upcase
    table_names(false).each{ |table|
      return true if table.upcase == nm
    }
    return false
  end
end

#### dataset class for ADOConnection ####

class ADODataSet
  include DataSet_ex
  undef apply_updates if defined? apply_updates ## 2003-01-08()
  def apply_updates(*args);0;end
end

class ADOTable
  include DataSet_ex
  undef apply_updates if defined? apply_updates ## 2003-01-08()
  def apply_updates(*args);0;end
end

class ADOQuery
  include DataSet_ex
  undef apply_updates if defined? apply_updates ## 2003-01-08()
  def apply_updates(*args);0;end
  def sql_text
    self.sql.text
  end
  def sql_text=(v)
    self.sql.text = v
  end
  def sql_params
    self.parameters
  end
end

## ADOConnection ##

class Parameters
  def values
    hash = {}
    self.each{|param| hash[param.name] = param.value }
    return hash
  end
end

end # of module Phi
end # of if $NO_PHI_EXTENSION
