require 'phi'
require 'find'
require 'dialogs'

form = Phi::Form.new(:form1, 'tH[ł')
form.height = 400

panel = Phi::Panel.new(form, :form1, '')
panel.align = Phi::AL_TOP
panel.height = 24
button = Phi::Button.new(panel, :button1, 'tH_I')
button.align = Phi::AL_RIGHT
button.width = 100
edit = Phi::Edit.new(panel, :edit1, '')
edit.align = Phi::AL_CLIENT
edit.width = panel.width - button.width
edit.text = 'd:/docu/document/apollo'

show_btn = Phi::Button.new(form, :show_btn1, '\')
show_btn.align = Phi::AL_BOTTOM

treeview = Phi::TreeView.new(form, :treeview1, '')
treeview.align = Phi::AL_CLIENT
nodes = treeview.items

button.on_click = proc do 
  result_path = ''
  if Phi::select_dir('tH_[IĂ', '/', result_path)
    edit.text = result_path
    form.set_focus
  end
end

show_btn.on_click = proc do
  if edit.text != '' and FileTest::directory?(edit.text)
    nodes.clear
    nodes.update {
      path = File::expand_path(edit.text)
      dir = {}
      top_node = nodes.add(nil, File::dirname(path))
      dir[File::dirname(path)] = top_node
      Find::find(edit.text) do |f|
	dirname = File::dirname(f)
	node = nodes.add_child(dir[dirname], File::basename(f))
	if FileTest::directory?(f)
	  dir[f] = node
	end
      end
    }
  else
    Phi::message_dlg(edit.text + ' ̓tH_[ł͂܂B', 
		     Phi::MT_ERROR, [Phi::MB_OK], 0)
  end
end

form.show
Phi.mainloop
