program Apollo_q;

uses
  SysUtils,
  Windows,
  Registry;

{$R *.res}

const

  VERSION = 'Apollo -q + Chameleon Loader. ver.1.02 2002-11-01';
  AUTHOR_J= '(tk) ( ggb03124@nifty.ne.jp )';
  AUTHOR_E= 'kumagai hidetake( ggb03124@nifty.ne.jp )';
  NL = ^m^j;

// ---- from tkUtils.pas

function GetRegValue( const Root:HKEY;const Key,ID:string ):string;
begin
  Result := '';
  with TRegistry.Create do try
    RootKey := Root;
    if OpenKey( Key , false ) then try
      Result:= ReadString( ID );
    finally CloseKey ; end;
  finally Free ; end;
end;

const RegAppKey:string='Software\Microsoft\Windows\CurrentVersion\App Paths\' ;

function GetAppPath(ExeName: String): String;
begin
  ExeName := ExtractFileName( ExeName );
  if ExtractFileExt( ExeName )='' then ExeName := ExeName+'.exe';
  result := GetRegValue( HKEY_LOCAL_MACHINE , RegAppKey+ExeName , '' );
end;

function GetEnv( const name:string ):string;
var d:integer;
begin
   SetLength(result,1024*4);
   d:=GetEnvironmentVariable( Pchar(name),PChar(result),length(result));
   SetLength(result,d);
end;

function SearchPath_ex( const name:string ):string;
begin
  result := FileSearch( name , GetEnv('Path') );
  if result <> '' then exit;
  result := FileSearch( name , GetEnv('RubyLib') );
end;

// ----

procedure say( msg:string );
begin
  MessageBox(0,PChar(msg),'apollo_q',0); // 0:err
end;

procedure Usage0( alias_name:string);
var
  msg : string;
begin
  if SysLocale.PriLangID = LANG_JAPANESE then begin
    msg :=
      alias_name+'F '+VERSION + NL+
      '          by '+AUTHOR_J + NL+
      NL+
      'Apollo.exe ̏ݒn܂B' + NL+
      'ݒno^EXVɂ́A' + NL+
      '_E[h Apollo ̃fBNgɂ' + NL+
      'AppPath.exe sĂB' + NL
  end else begin
    msg :=
      alias_name+'F '+VERSION + NL+
      '          by '+AUTHOR_E + NL+
      NL+
      'Cannot find "apollo.exe"' + NL+
      'In order to register the location of "apollo.exe",' + NL+
      'please run AppPath.exe on the directory of latest Apollo.' + NL
  end;     
  say(msg);
end;

procedure Usage1( alias_name,apollo_exe:string);
var
  msg : string;
begin
  if SysLocale.PriLangID = LANG_JAPANESE then begin
    msg :=
      alias_name+'F '+VERSION + NL+
      '          by '+AUTHOR_J + NL+NL+
      'apollo.exe ̍ŐV̏ݒn' + NL+
      '  ['+apollo_exe+']łB' + NL+NL+
      'apollo_q ɈtĎs΁AŐV apollo.exe  -q IvVtŋN܂' + NL+NL+
      'ݒno^EXVɂ́A' + NL+
      '_E[h Apollo ̃fBNgɂ' + NL+
      'AppPath.exe sĂB' + NL+NL+
      'yJI@\z' + NL+
      '̃R}hXNvgƓOɂƁA' + NL+
      '̃XNvg apollo_q.exe Ŏs܂B' + NL+NL+
      'copy apollo_q.exe hoge.exe' + NL+
      'hoge' + NL+
      '  == apollo_q hoge.rb' + NL
  end else begin
    msg :=
      alias_name+'F '+VERSION + NL+
      '          by '+AUTHOR_E + NL+NL+
      'The location of recognized "apollo.exe" is' + NL+
      '  ['+apollo_exe+'].' + NL+NL+
      'Please run "apollo_q.exe" with scrpit_file_name,' + NL+
      'then it runs the latest "apollo.exe" with "-q" option.' + NL+NL+
      'In order to register the location of "apollo.exe",' + NL+
      'please run AppPath.exe in the directory of latest Apollo.' + NL+NL+
      'apollo_q as CHAMELEON:' + NL+
      'If you rename this command to the same name of script FOO.rb, e.g. FOO.exe' + NL+
      'FOO.exe runs "apollo_q FOO.rb" in the same directory.' + NL+NL+
      'copy apollo_q.exe FOO.exe' + NL+
      'FOO' + NL+
      '  == apollo_q FOO.rb' + NL
  end;
  if CmdLine <> '' then begin
    msg := msg + NL+NL+'== ERROR == '+NL+ 'cannot find script from the command line:' + NL + '  "'+CmdLine+'"' ;
  end;
  say(msg);
end;

function SplitParam( var rest:string ):string;
var
  delimitter:char;
  p:integer;
begin
  rest := TrimLeft(rest);
  if rest = '' then begin
    result := '';
    rest   := '';
    exit;
  end;
  delimitter := ' ';
  if rest[1] = '''' then delimitter := '''';
  if rest[1] = '"'  then delimitter := '"';
  p := pos(delimitter,copy(rest,2,maxint))+1;
  if p = 1 then begin
    result := trim(rest);
    rest   := '';
  end else begin
    result := trim(copy(rest,1,p));
    rest   := copy(rest,p+1,MaxInt);
  end;
end;

procedure do_apollo_q;
var
  alias_name,alias_path,script,apollo_exe,options:string;
  rest:string;  //++
begin
  script := '';
  alias_name := 'apollo_q';      //  for msg
  alias_path := ParamStr(0);    //  for run
  rest := CmdLine;
  SplitParam(rest) ; 	//	dispose ParamStr(0)
  options := rest;
  script := SplitParam(rest);
  script := AnsiDequotedStr(script,'"');

  if Pos( 'APOLLO_Q.EXE', UpperCase(alias_path) ) <> 0 then begin
    alias_path := '';
    if ( length(script) = 0 ) or ( script[1] = '-' ) then begin
      script := '';
    end else begin
      options := rest;
      if ExtractFileExt( script ) = '' then script := script + '.rb';
      if not FileExists(script) then script := SearchPath_ex( script );
    end;
  end else begin
    alias_path := AnsiDequotedStr(alias_path,'"');
    script := ChangeFileExt(ExpandFileName(alias_path),'.rb');
    if not FileExists(script)
      then script := SearchPath_ex( ExtractFileName(script) );
    alias_name := 'apollo_q(=>'+ExtractFileName(alias_path)+')';
  end;

  apollo_exe := GetAppPath( 'apollo.exe' );
  if apollo_exe = '' then begin
    Usage0( alias_name );
    exit;
  end;

  if (script = '' ) then begin
    Usage1( alias_name,apollo_exe);
    exit;
  end;

  script := AnsiQuotedStr(script,'"') ;
  WinExec( PChar(apollo_exe  +' -q '+ script +' '+ options),SW_SHOWNORMAL);
end;

begin
  do_apollo_q;
end.
