unit InternetHandle;

interface

uses
  Windows, Classes, Controls, Forms, contnrs, Rubies, ScktComp;

type
  TInternetHandle = class(TObject)
  public
    procedure doConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure doConnecting(Sender: TObject; Socket: TCustomWinSocket);
    procedure doDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure doRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure doWrite(Sender: TObject; Socket: TCustomWinSocket);
    procedure doError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
    procedure doClientConnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure doClientDisconnect(Sender: TObject; Socket: TCustomWinSocket);
    procedure doClientRead(Sender: TObject; Socket: TCustomWinSocket);
    procedure doClientWrite(Sender: TObject; Socket: TCustomWinSocket);
    procedure doClientError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
  end;

var
  Handle: TInternetHandle;
  cCustomWinSocket,
  cServerWinSocket,
  cClientWinSocket,
  cServerSocket,
  cClientSocket: Tvalue;

implementation

uses Pythia;

function CustomWinSocket_alloc(This: Tvalue; real: TCustomWinSocket): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

procedure TInternetHandle.doConnect(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_connect'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doConnecting(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_connecting'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doDisconnect(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_disconnect'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doRead(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_read'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doWrite(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_write'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
var
  recv, data, ret: Tvalue;
begin
  recv := TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_error'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  rb_ary_push(data, INT2FIX(Ord(ErrorEvent)));
  ret := PhiCallProtect(data);
  if ret <> Qnil then ErrorCode := dl_Integer(ret);
end;

procedure TInternetHandle.doClientConnect(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := cServerSocket; //TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_client_connect'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doClientDisconnect(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := cServerSocket; //TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_client_disconnect'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doClientRead(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := cServerSocket; //TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_client_read'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doClientWrite(Sender: TObject; Socket: TCustomWinSocket);
var
  recv, data: Tvalue;
begin
  recv := cServerSocket; //TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_client_write'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  PhiCallProtect(data);
end;

procedure TInternetHandle.doClientError(Sender: TObject; Socket: TCustomWinSocket; ErrorEvent: TErrorEvent; var ErrorCode: Integer);
var
  recv, data, ret: Tvalue;
begin
  recv := cServerSocket; //TComponent(Sender).tag;
  data := rb_ary_new;
  rb_ary_push(data, rb_intern('on_client_error'));
  rb_ary_push(data, recv);
  rb_ary_push(data, CustomWinSocket_alloc(cCustomWinSocket, Socket));
  rb_ary_push(data, INT2FIX(Ord(ErrorEvent)));
  ret := PhiCallProtect(data);
  if ret <> Qnil then ErrorCode := dl_Integer(ret);
end;

initialization
  Handle := TInternetHandle.Create;
finalization
  Handle.Free;
end.
