unit uADOStoredProc;

interface

uses ADODB, Rubies;

var
  cADOStoredProc: Tvalue;

function ap_cADOStoredProc: Tvalue;
function ap_iADOStoredProc(real: TADOStoredProc; owner: Tvalue): Tvalue;
procedure Init_ADOStoredProc;

implementation

uses uDefUtils, Pythia, uRDBExt{, uDataSet}, uADODataSet, uParameter;

function ap_cADOStoredProc: Tvalue;
begin
  result := cADOStoredProc;
end;

procedure ADOStoredProc_setup(obj: Tvalue; real: TADOStoredProc);
begin
  DataSet_setup(obj, real);
end;

function ADOStoredProc_alloc(This: Tvalue; real: TADOStoredProc): Tvalue;
begin
  result := ChildAlloc(This, real);
  ADOStoredProc_setup(result, real);
end;

function ap_iADOStoredProc(real: TADOStoredProc; owner: Tvalue): Tvalue;
begin
  result := ADOStoredProc_alloc(cADOStoredProc, real);
  ap_owner(result, owner);
end;

function ap_iADOStoredProc_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iADOStoredProc(TADOStoredProc(obj), owner);
end;

function ADOStoredProc_new(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TADOStoredProc;
begin
  real := TADOStoredProc.Create(nil);
  result := DataSet_alloc(This, real);
  ADOStoredProc_setup(result, real);

  rb_obj_call_init(result, argc, argv);
end;

function ADOStoredProc_exec_proc(This: Tvalue): Tvalue; cdecl;
var
  real: TADOStoredProc;
begin
  real := ap_data_get_struct(This);
  real.ExecProc;
  result := Qnil;
end;

function ADOStoredProc_get_parameters(This: Tvalue): Tvalue; cdecl;
var
  real: TADOStoredProc;
begin
  real := ap_data_get_struct(This);
  result := ap_iParameters(real.Parameters, This);
end;

procedure Init_ADOStoredProc;
begin
  cADOStoredProc := DefinePersistentClass(ap_mRDB, TADOStoredProc, cADODataSet, ap_iADOStoredProc_v);
  DefineSingletonMethod(cADOStoredProc, 'new', ADOStoredProc_new);
  rb_define_method(cADOStoredProc, 'exec_proc', @ADOStoredProc_exec_proc, 0);
  DefineAttrGet(cADOStoredProc, 'parameters', ADOStoredProc_get_parameters);
end;

end.
