unit uDBListBox;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBListBox = class(TDBListBox)
//  published
//    property Text;
  end;

var
  cDBListBox: Tvalue;

function ap_iDBListBox(real: TPhi_DBListBox; owner: Tvalue): Tvalue;
procedure Init_DBListBox;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBListBox_setup(obj: Tvalue; real: TPhi_DBListBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBListBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBListBox_alloc(This: Tvalue; real: TPhi_DBListBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBListBox_setup(result, real);
end;

function ap_iDBListBox(real: TPhi_DBListBox; owner: Tvalue): Tvalue;
begin
  result := DBListBox_alloc(cDBListBox, real);
  ap_owner(result, owner);
end;

function ap_iDBListBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBListBox(TPhi_DBListBox(AControl), owner)
end;

function DBListBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBListBox;
begin
  real := TPhi_DBListBox.Create(nil);
  result := CompoAlloc(This, real);
  DBListBox_setup(result, real);
end;

function DBListBox_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBListBox;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBListBox_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBListBox;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBListBox;
begin
  cDBListBox := DefinePersistentClass(mRDB, TPhi_DBListBox, ap_cListBox, ap_iDBListBox_v);
  rb_define_method(cDBListBox, 'event_handle', @DBListBox_event_handle, 1);
  rb_define_alloc_func(cDBListBox, @DBListBox_allocate);
  DefineAttrSet(cDBListBox, 'data_source', DBListBox_set_data_source);
  DefineAttrSet(cDBListBox, 'data_field', DBListBox_set_data_field);
end;

end.
