library strprn;

(****
needs for compile
http://member.nifty.ne.jp/~katsuhiko/
http://member.nifty.ne.jp/~katsuhiko/vcl/tstringsprinter/strprn22.lzh
****)

uses SysUtils, Classes, heClasses, StrPrint, strpefm, Rubies, uDefUtils, Pythia;

{$E so}

{$SOPREFIX ''}

var
  cStoreComponent, cStringsPrinter, cFormStringsPrint: Tvalue;

function StoreComponent_read_ini(This, fname, section, ident: Tvalue): Tvalue; cdecl;
var
  real: TStoreComponent;
begin
  real := ap_data_get_struct(This);
  real.ReadIni(dl_String(fname), dl_String(section), dl_string(ident));
  result := This;
end;

function StoreComponent_write_ini(This, fname, section, ident: Tvalue): Tvalue; cdecl;
var
  real: TStoreComponent;
begin
  real := ap_data_get_struct(This);
  real.WriteIni(dl_String(fname), dl_String(section), dl_string(ident));
  result := This;
end;

function StringsPrinter_new(This: Tvalue): Tvalue; cdecl;
var
  real: TStringsPrinter;
begin
  real := TStringsPrinter.Create(nil);
  result := ObjAlloc(This, real);
  ap_obj_call_init(result, 0, nil);
end;

function StringsPrinter_print_strings(This, strs: Tvalue): Tvalue; cdecl;
var
  real: TStringsPrinter;
  Strings: TStrings;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(strs, TStrings, Strings);
  result := ap_bool(real.PrintStrings(Strings));
end;

procedure FormStringsPrint_setup(obj: Tvalue; real: TFormStringsPrint);
begin
//
end;

function FormStringsPrint_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [PhiGetHandle]);
  result := Qnil;
end;

function FormStringsPrint_alloc(klass: Tvalue; real: TFormStringsPrint): Tvalue;
begin
  result := ChildAlloc(klass, real);
  FormStringsPrint_setup(result, real);
end;

function ap_iFormStringsPrint(real: TFormStringsPrint; owner: Tvalue): Tvalue;
begin
  result := FormStringsPrint_alloc(cFormStringsPrint, real);
  ap_owner(result, owner);
end;

function ap_iFormStringsPrint_v(var obj; owner: Tvalue): Tvalue;
begin
  result := ap_iFormStringsPrint(TFormStringsPrint(obj), owner)
end;

function FormStringsPrint_execute(This, sprn, strs: Tvalue): Tvalue; cdecl;
var
  StringsPrinter: TStringsPrinter;
  Strings: TStrings;
begin
  ap_data_get_object(sprn, TStringsPrinter, StringsPrinter);
  ap_data_get_object(strs, TStrings, Strings);
  result := ap_bool(TFormStringsPrint.Execute(StringsPrinter, Strings));
end;

procedure Init_strprn;
begin
  PhiStart;

  cStoreComponent := rb_define_class_under(ap_mPhi, 'StoreComponent', ap_cComponent);
  rb_define_method(cStoreComponent, 'read_ini', @StoreComponent_read_ini, 3);
  rb_define_method(cStoreComponent, 'write_ini', @StoreComponent_write_ini, 3);

//  cStringsPrinter := rb_define_class_under(ap_mPhi, 'StringsPrinter', cStoreComponent);
  cStringsPrinter := DefinePersistentClass(ap_mPhi, TStringsPrinter, cStoreComponent, nil);
  rb_define_singleton_method(cStringsPrinter, 'new', @StringsPrinter_new, 0);
  rb_define_method(cStringsPrinter, 'print_strings', @StringsPrinter_print_strings, 1);

  cFormStringsPrint := DefinePersistentClass(ap_mPhi, TFormStringsPrint, ap_cWinControl, ap_iFormStringsPrint_v);
  rb_define_singleton_method(cFormStringsPrint, 'execute', @FormStringsPrint_execute, 2);
end;

exports
  Init_strprn;

end.
