require "test/unit"
require "phi"
class TCEdit < Test::Unit::TestCase
  def test_ancestors
    assert_equal Phi::WinControl, Phi::Edit.superclass
  end

  def setup
    @form = Phi::Form.new(:form)
  end

  def test_new_iv
    instance = Phi::Edit.new(@form, :edit)
    assert_equal Hash.new, instance.instance_eval { @events }
    assert_equal @form, instance.instance_eval { @parent }
  end

  def test_tag
    instance = Phi::Edit.new(@form, :edit)
    assert_raise(NoMethodError) { instance.tag }
  end

  def test_new_name_default
    instance = Phi::Edit.new(@form)
    assert_equal 'Edit1', instance.name
    assert_equal instance, @form.instance_eval { @Edit1 }
    assert_equal instance, @form.instance_eval { self.Edit1 }
  end

  def test_new_name
    instance = Phi::Edit.new(@form, :edit)
    assert_equal 'edit', instance.name
    assert_equal instance, @form.instance_eval { @edit }
    assert_equal instance, @form.instance_eval { self.edit }
  end

  def test_new_text_default
    instance = Phi::Edit.new(@form, :edit)
    assert_equal '', instance.text
  end

  def test_new_text
    instance = Phi::Edit.new(@form, :edit, 'hello')
    assert_equal 'hello', instance.text
  end

  def test_font
    instance = Phi::Edit.new(@form, :edit)
    assert_instance_of Phi::Font, instance.font
  end
end

class SubEdit < Phi::Edit
  def initialize(*args)
    @form = Phi::Form.new(:form)
    super(@form, :edit, *args)
  end
end

class TCSubEdit < Test::Unit::TestCase
  def test_new
    instance = nil
    assert_nothing_raised { instance = SubEdit.new('ab.cd') }
    assert_equal 'edit', instance.name
    assert_equal 'ab.cd', instance.text
  end
end
