unit uAction;

interface

uses
  Classes,
{$IFDEF VCL}
  Forms,
  ActnList,
{$ELSE}
  QForms,
  QActnList,
{$ENDIF}
  Rubies;

var
  cBasicAction: Tvalue;
  cContainedAction: Tvalue;
  cAction: Tvalue;

function ap_cBasicAction: Tvalue;
procedure BasicAction_setup(obj: Tvalue; real: TBasicAction);
function BasicAction_alloc(This: Tvalue; real: TBasicAction): Tvalue;
function ap_iBasicAction(real: TBasicAction; owner: Tvalue): Tvalue;

function ap_cContainedAction: Tvalue;
procedure ContainedAction_setup(obj: Tvalue; real: TContainedAction);
function ContainedAction_alloc(This: Tvalue; real: TContainedAction): Tvalue;
function ap_iContainedAction(real: TContainedAction; owner: Tvalue): Tvalue;

function ap_cAction: Tvalue;
procedure Action_setup(obj: Tvalue; real: TAction);
function Action_alloc(This: Tvalue; real: TAction): Tvalue;
function ap_iAction(real: TAction; owner: Tvalue): Tvalue;

procedure Init_Action;

implementation

uses
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cBasicAction: Tvalue;
begin
  result := cBasicAction;
end;

procedure BasicAction_setup(obj: Tvalue; real: TBasicAction);
begin
//
end;

function BasicAction_alloc(This: Tvalue; real: TBasicAction): Tvalue;
begin
  result := ChildAlloc(This, real);
  BasicAction_setup(result, real);
end;

function ap_iBasicAction(real: TBasicAction; owner: Tvalue): Tvalue;
begin
  result := BasicAction_alloc(cBasicAction, real);
  ap_owner(result, owner);
end;

function ap_iBasicAction_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iBasicAction(TBasicAction(AControl), owner);
end;

function BasicAction_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TBasicAction;
begin
  real := TBasicAction.Create(nil);
  result := CompoAlloc(This, real);
  BasicAction_setup(result, real);
end;

function BasicAction_get_action_component(This: Tvalue): Tvalue; cdecl;
var
  real: TBasicAction;
  AComponent: TComponent;
begin
  real := ap_data_get_struct(This);
  result := Qnil;
  AComponent := real.ActionComponent;
  if AComponent <> nil then
    result := AComponent.tag;
end;

function ap_cContainedAction: Tvalue;
begin
  result := cContainedAction;
end;

procedure ContainedAction_setup(obj: Tvalue; real: TContainedAction);
begin
//
end;

function ContainedAction_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ContainedAction_alloc(This: Tvalue; real: TContainedAction): Tvalue;
begin
  result := ChildAlloc(This, real);
  ContainedAction_setup(result, real);
end;

function ap_iContainedAction(real: TContainedAction; owner: Tvalue): Tvalue;
begin
  result := ContainedAction_alloc(cContainedAction, real);
  ap_owner(result, owner);
end;

function ap_iContainedAction_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iContainedAction(TContainedAction(AControl), owner);
end;

function ContainedAction_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TContainedAction;
begin
  real := TContainedAction.Create(nil);
  result := CompoAlloc(This, real);
  ContainedAction_setup(result, real);
end;

function ContainedAction_get_action_list(This: Tvalue): Tvalue; cdecl;
var
  real: TContainedAction;
  CActionList: TCustomActionList;
begin
  real := ap_data_get_struct(This);
  result := Qnil;
  CActionList := real.ActionList;
  if CActionList <> nil then
    result := CActionList.tag;
end;

function ContainedAction_set_action_list(This, v: Tvalue): Tvalue; cdecl;
var
  real: TContainedAction;
  CActionList: TCustomActionList;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TCustomActionList, CActionList);
  real.ActionList := CActionList;
  result := v;
end;

function ContainedAction_get_index(This: Tvalue): Tvalue; cdecl;
var
  real: TContainedAction;
begin
  real := ap_data_get_struct(This);
  result := ap_Fixnum(real.Index);
end;

function ContainedAction_set_index(This, v: Tvalue): Tvalue; cdecl;
var
  real: TContainedAction;
begin
  real := ap_data_get_struct(This);
  real.Index := dl_Integer(v);
  result := v;
end;

function ap_cAction: Tvalue;
begin
  result := cAction;
end;

procedure Action_setup(obj: Tvalue; real: TAction);
begin
//
end;

function Action_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Action_alloc(This: Tvalue; real: TAction): Tvalue;
begin
  result := ChildAlloc(This, real);
  Action_setup(result, real);
end;

function ap_iAction(real: TAction; owner: Tvalue): Tvalue;
begin
  result := Action_alloc(cAction, real);
  ap_owner(result, owner);
end;

function ap_iAction_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iAction(TAction(AControl), owner);
end;

function Action_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TAction;
begin
  real := TAction.Create(nil);
  result := CompoAlloc(This, real);
  Action_setup(result, real);
end;

procedure Init_Action;
begin
  cBasicAction := OutputPersistentClass(mPhi, TBasicAction, cComponent, ap_iBasicAction_v);
  rb_define_method(cBasicAction, 'event_handle', @Action_event_handle, 1);
  rb_define_alloc_func(cBasicAction, @BasicAction_allocate);
  DefineAttrGet(cBasicAction, 'action_component', BasicAction_get_action_component);

  cContainedAction := OutputPersistentClass(mPhi, TContainedAction, cBasicAction, ap_iContainedAction_v);
  rb_define_alloc_func(cContainedAction, @ContainedAction_allocate);
  DefineAttrGet(cContainedAction, 'index', ContainedAction_get_index);
  DefineAttrSet(cContainedAction, 'index', ContainedAction_set_index);
  DefineAttrGet(cContainedAction, 'action_list', ContainedAction_get_action_list);
  DefineAttrSet(cContainedAction, 'action_list', ContainedAction_set_action_list);

  cAction := OutputPersistentClass(mPhi, TAction, cContainedAction, ap_iAction_v);
  rb_define_method(cAction, 'event_handle', @Action_event_handle, 1);
  rb_define_alloc_func(cAction, @Action_allocate);
end;


end.
