unit uBrush;

interface

uses
{$IFDEF VCL}
  Graphics,
{$ELSE}
  QGraphics,
{$ENDIF}
  Rubies;

var
  cBrush: Tvalue;

function ap_cBrush: Tvalue;
function ap_iBrush(real: TBrush; owner: Tvalue): Tvalue;
procedure Init_Brush;

implementation

uses
  Classes,
  uDefUtils, uIntern, uAlloc, uProp, uPhi,
  uBitmap;

function ap_cBrush: Tvalue;
begin
  result := cBrush;
end;

procedure Brush_setup(obj: Tvalue; real: TBrush);
begin
//
end;

function Brush_alloc(klass: Tvalue; real: TBrush): Tvalue;
begin
  result := TmpAlloc(klass, real);
  Brush_setup(result, real);
end;

function ap_iBrush(real: TBrush; owner: Tvalue): Tvalue;
begin
  result := Brush_alloc(cBrush, real);
  ap_owner(result, owner);
end;

function Brush_new(This: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
begin
  real := TBrush.Create;
  result := ObjAlloc(This, real);
  Brush_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

function Brush_assign(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
  source: TPersistent;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TPersistent, source);
  real.Assign(source);
  result := v;
end;

function Brush_set_bitmap(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
  bitmap: TBitmap;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TBitmap, bitmap);
  real.Bitmap := bitmap;
  rb_iv_set(This, '@bitmap', v);
  result := v;
end;

function Brush_get_bitmap(This, v: Tvalue): Tvalue; cdecl;
var
  real: TBrush;
begin
  real := ap_data_get_struct(This);
  if real.Bitmap = nil then result := Qnil else
  result := ap_iBitmap(real.Bitmap, This);
end;

procedure Init_Brush;
begin
  OutputConstSetType(mPhi, TypeInfo(TBrushStyle));

  cBrush := rb_define_class_under(mPhi, 'Brush', ap_cObject);
  OutputProp(cBrush, TBrush);

  rb_define_singleton_method(cBrush, 'new', @Brush_new, 0);
  rb_define_method(cBrush, 'assign', @Brush_assign, 1);
  DefineAttrSet(cBrush, 'bitmap', @Brush_set_bitmap);
  DefineAttrGet(cBrush, 'bitmap', @Brush_get_bitmap);
end;

end.
