unit uGroupBox;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cGroupBox: Tvalue;

function ap_cGroupBox: Tvalue;
function ap_iGroupBox(real: TGroupBox; owner: Tvalue): Tvalue;
procedure Init_GroupBox;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cGroupBox: Tvalue;
begin
  result := cGroupBox;
end;

procedure GroupBox_setup(obj: Tvalue; real: TGroupBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//    AssignPropMethod(real, [Handle]);
end;

function GroupBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function GroupBox_alloc(This: Tvalue; real: TGroupBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  GroupBox_setup(result, real);
end;

function ap_iGroupBox(real: TGroupBox; owner: Tvalue): Tvalue;
begin
  result := GroupBox_alloc(cGroupBox, real);
  ap_owner(result, owner);
end;

function ap_iGroupBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iGroupBox(TGroupBox(AControl), owner)
end;

function GroupBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TGroupBox;
begin
  real := TGroupBox.Create(nil);
  result := CompoAlloc(This, real);
  GroupBox_setup(result, real);
end;

procedure Init_GroupBox;
begin
  cGroupBox := OutputPersistentClass(mPhi, TGroupBox, cWinControl, ap_iGroupBox_v);
  rb_define_method(cGroupBox, 'event_handle', @GroupBox_event_handle, 1);
  rb_define_alloc_func(cGroupBox, @GroupBox_allocate);
end;

end.
