unit uToolBar;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cToolBar: Tvalue;
  cToolButton: Tvalue;

function ap_cToolBar: Tvalue;
function ap_iToolBar(real: TToolBar; owner: Tvalue): Tvalue;
function ap_cToolButton: Tvalue;
function ap_iToolButton(real: TToolButton; owner: Tvalue): Tvalue;
procedure Init_ToolBar;

implementation

uses
{$IFDEF VCL}
  ToolWin,
{$ENDIF}
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uCanvas, uFont,
  uPersistent, uComponent, uControl;

function ap_cToolBar: Tvalue;
begin
  result := cToolBar;
end;

procedure ToolBar_setup(obj: Tvalue; real: TToolBar);
begin
{$IFDEF VCL}
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
{$ENDIF}
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function ToolBar_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ToolBar_alloc(This: Tvalue; real: TToolBar): Tvalue;
begin
  result := ChildAlloc(This, real);
  ToolBar_setup(result, real);
end;

function ap_iToolBar(real: TToolBar; owner: Tvalue): Tvalue;
begin
  result := ToolBar_alloc(cToolBar, real);
  ap_owner(result, owner);
end;

function ap_iToolBar_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iToolBar(TToolBar(AControl), owner);
end;

function ToolBar_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TToolBar;
begin
  real := TToolBar.Create(nil);
  result := CompoAlloc(This, real);
  ToolBar_setup(result, real);
end;

{$IFDEF VCL}
function ToolBar_flip_children(This, v: Tvalue): Tvalue; cdecl;
var
  real: TToolBar;
begin
  real := ap_data_get_struct(This);
  real.FlipChildren(RTEST(v));
  result := This;
end;

function ToolBar_buttons(This, i: Tvalue): Tvalue; cdecl;
var
  real: TToolBar;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(i);
  result := This;
  try
    result := real.Buttons[n].tag;
  except
    on E: Exception do
      ap_raise(ap_eArgError, PChar(E.message));
  end;
end;

function ToolBar_get_row_count(This: Tvalue): Tvalue; cdecl;
var
  real: TToolBar;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.RowCount);
end;
{$ENDIF}

function ToolBar_get_button_count(This: Tvalue): Tvalue; cdecl;
var
  real: TToolBar;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.ButtonCount);
end;

function ap_cToolButton: Tvalue;
begin
  result := cToolButton;
end;

procedure ToolButton_setup(obj: Tvalue; real: TToolButton);
begin
//    AssignPropMethod(real, [Handle]);
end;

function ToolButton_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ToolButton_alloc(This: Tvalue; real: TToolButton): Tvalue;
begin
  result := ChildAlloc(This, real);
  ToolButton_setup(result, real);
end;

function ap_iToolButton(real: TToolButton; owner: Tvalue): Tvalue;
begin
  result := ToolButton_alloc(cToolButton, real);
  ap_owner(result, owner);
end;

function ap_iToolButton_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iToolButton(TToolButton(AControl), owner);
end;

function ToolButton_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TToolButton;
begin
  real := TToolButton.Create(nil);
  result := CompoAlloc(This, real);
  ToolButton_setup(result, real);
end;

function ToolButton_get_index(This: Tvalue): Tvalue; cdecl;
var
  real: TToolButton;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Index);
end;

procedure Init_ToolBar;
begin
{$IFDEF VCL}
  OutputConstSetType(mPhi, TypeInfo(TEdgeBorder));
{$ENDIF}
  cToolBar := OutputPersistentClass(mPhi, TToolBar, cWinControl, ap_iToolBar_v);
  rb_define_method(cToolBar, 'event_handle', @ToolBar_event_handle, 1);
  rb_define_alloc_func(cToolBar, @ToolBar_allocate);
{$IFDEF VCL}
  rb_define_method(cToolBar, 'buttons', @ToolBar_buttons, 1);
  rb_define_method(cToolBar, 'flip_children', @ToolBar_flip_children, 1);
  DefineAttrGet(cToolBar, 'row_count', ToolBar_get_row_count);
{$ENDIF}
  DefineAttrGet(cToolBar, 'button_count', ToolBar_get_button_count);

  OutputConstSetType(mPhi, TypeInfo(TToolButtonStyle));
  cToolButton := OutputPersistentClass(mPhi, TToolButton, cWinControl, ap_iToolButton_v);
  rb_define_method(cToolButton, 'event_handle', @ToolButton_event_handle, 1);
  rb_define_alloc_func(cToolButton, @ToolButton_allocate);

  DefineAttrGet(cToolButton, 'index', ToolButton_get_index);
end;

end.

