#!/usr/bin/env ruby

text_exts = %w[
  txt
  rb
  pas
  dpr
  html
  htm
]

def cutcr(src)
  tmp = src + '~'
  File.rename src, tmp
  open(tmp, 'rb'){|i|
  open(src, 'wb'){|o|
    while i.gets("\r\n")
      sub!(/\r/, '')
      o.print
    end
  }}
end

Dir.glob('**/*'){|entry|
  pos = entry.rindex('.')
  next if pos.nil?
  ext = entry[pos+1..-1]
  if text_exts.include? ext
    $stderr.print "cutcr #{entry}\n"
    cutcr entry
  end
}
