/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.api.server.spi.BackendService;
import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.ServiceContext;
import com.google.api.server.spi.ServiceException;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiConfigException;
import com.google.api.server.spi.config.ApiConfigLoader;
import com.google.api.server.spi.config.ApiConfigWriter;
import com.google.api.server.spi.config.ApiKey;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.ApiSerializationConfig;
import com.google.api.server.spi.config.validation.ApiConfigValidator;
import com.google.api.server.spi.request.ParamReader;
import com.google.api.server.spi.response.BadRequestException;
import com.google.api.server.spi.response.InternalServerErrorException;
import com.google.api.server.spi.response.ResultWriter;
import com.google.api.server.spi.response.UnauthorizedException;
import com.google.appengine.api.oauth.OAuthRequestException;
import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.FluentIterable;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SystemService {
    private static final Logger logger = Logger.getLogger(SystemService.class.getName());
    public static final String MIME_JSON = "application/json; charset=UTF-8";
    public static final int DUPLICATE_SERVICE_REGISTER_COUNT = -1;
    private static final Predicate<ApiConfig> NON_INTERNAL_PREDICATE = new Predicate<ApiConfig>(){

        public boolean apply(ApiConfig config) {
            return !"_GoogleCloudEndpointsInternal".equals(config.getName());
        }
    };
    private static final Function<EndpointNode, ApiConfig> ENDPOINT_NODE_TO_API_CONFIG = new Function<EndpointNode, ApiConfig>(){

        public ApiConfig apply(EndpointNode node) {
            return node.config;
        }
    };
    private final Map<String, List<Object>> servicesByName = new HashMap<String, List<Object>>();
    private final ConcurrentMap<Object, EndpointNode> endpoints = new ConcurrentHashMap<Object, EndpointNode>();
    private final Map<String, String> serviceApiVersions = new HashMap<String, String>();
    private final Map<String, ApiSerializationConfig> serializationConfigs = new HashMap<String, ApiSerializationConfig>();
    private final Multimap<String, ApiConfig> initialConfigsByApi = ArrayListMultimap.create();
    private final ApiConfigLoader configLoader;
    private final ApiConfigValidator validator;
    private final ServiceContext serviceContext;
    private final ApiConfigWriter configWriter;

    public SystemService(ApiConfigLoader configLoader, ApiConfigValidator validator, String appName, ApiConfigWriter configWriter, Object[] services) throws ApiConfigException {
        this(configLoader, validator, appName, configWriter);
        for (Object service : services) {
            this.registerService(service);
        }
    }

    public SystemService(ApiConfigLoader configLoader, ApiConfigValidator validator, String appName, ApiConfigWriter configWriter) throws ApiConfigException {
        this.configLoader = configLoader;
        this.validator = validator;
        this.serviceContext = ServiceContext.create(appName, "myapi");
        this.configWriter = configWriter;
        this.registerInternalService(new BackendService(this));
    }

    public <T> int registerService(Class<T> serviceClass, T service) throws ApiConfigException {
        ApiConfig apiConfig = this.configLoader.loadConfiguration(this.serviceContext, serviceClass);
        return this.registerLoadedService(serviceClass, service, apiConfig, true);
    }

    public <T> int registerService(T service) throws ApiConfigException {
        Class<T> serviceClass = SystemService.getServiceClass(service);
        return this.registerService(serviceClass, service);
    }

    private <T> int registerInternalService(T service) throws ApiConfigException {
        Class<T> serviceClass = SystemService.getServiceClass(service);
        ApiConfig apiConfig = this.configLoader.loadInternalConfiguration(this.serviceContext, serviceClass);
        return this.registerLoadedService(serviceClass, service, apiConfig, false);
    }

    private <T> int registerLoadedService(Class<T> serviceClass, T service, ApiConfig apiConfig, boolean doValidation) throws ApiConfigException {
        String fullName = serviceClass.getName();
        if (!this.servicesByName.containsKey(fullName)) {
            String api = apiConfig.getName() + "-" + apiConfig.getVersion();
            if (doValidation) {
                this.validator.validate(Iterables.concat((Iterable)this.initialConfigsByApi.get((Object)api), Collections.singleton(apiConfig)));
            }
            this.initialConfigsByApi.put((Object)api, (Object)apiConfig);
            ApiSerializationConfig serializationConfig = this.serializationConfigs.get(api);
            if (serializationConfig == null) {
                serializationConfig = new ApiSerializationConfig();
            }
            for (ApiSerializationConfig.SerializerConfig rule : apiConfig.getSerializationConfig().getSerializerConfigs()) {
                serializationConfig.addSerializationConfig(rule.getSerializer());
            }
            this.serializationConfigs.put(api, serializationConfig);
            this.registerServiceFromName(service, serviceClass.getSimpleName(), api);
            this.registerServiceFromName(service, fullName, api);
            this.updateEndpointConfig(service, apiConfig, null);
            return apiConfig.getApiClassConfig().getMethods().size();
        }
        return -1;
    }

    public <T> EndpointNode updateEndpointConfig(T endpoint, ApiConfig newConfig, EndpointNode oldNode) {
        EndpointNode newNode = new EndpointNode(endpoint, newConfig);
        for (EndpointMethod method : newConfig.getApiClassConfig().getMethods().keySet()) {
            newNode.methods.put(method.getMethod().getName(), method);
        }
        if (oldNode == null) {
            this.endpoints.putIfAbsent(endpoint, newNode);
        } else {
            this.endpoints.replace(endpoint, oldNode, newNode);
        }
        return newNode;
    }

    void registerServiceFromName(final Object service, String name, String api) {
        ArrayList<Object> services = this.servicesByName.get(name);
        if (services == null) {
            services = new ArrayList<Object>(){
                {
                    this.add(service);
                }
            };
            this.servicesByName.put(name, (List<Object>)services);
        } else {
            services.add(service);
        }
        this.serviceApiVersions.put(name, api);
    }

    public EndpointMethod resolveService(String serviceName, String methodName) throws ServiceException {
        return this.getEndpointNode((String)serviceName).methods.get(methodName);
    }

    public ApiMethodConfig resolveAndUpdateServiceConfig(String serviceName, String methodName) throws ServiceException {
        ApiConfig newConfig;
        EndpointNode node = this.getEndpointNode(serviceName);
        if (this.configLoader.isStaticConfig(node.config)) {
            return this.getMethodConfigFromNode(node, methodName);
        }
        try {
            newConfig = this.configLoader.reloadConfiguration(this.serviceContext, SystemService.getServiceClass(node.endpoint), node.config);
            this.validator.validate(newConfig);
        }
        catch (ApiConfigException e) {
            logger.log(Level.WARNING, "Could not load new endpoint config, defaulting to old.", e);
            return this.getMethodConfigFromNode(node, methodName);
        }
        if (!newConfig.equals(node.config)) {
            this.updateEndpointConfig(node.endpoint, newConfig, node);
        }
        return this.getMethodConfigFromNode(this.getEndpointNode(serviceName), methodName);
    }

    private ApiMethodConfig getMethodConfigFromNode(EndpointNode node, String methodName) {
        return (ApiMethodConfig)node.config.getApiClassConfig().getMethods().get(node.methods.get(methodName));
    }

    public ApiSerializationConfig getSerializationConfig(String serviceName) {
        return this.serializationConfigs.get(this.serviceApiVersions.get(serviceName));
    }

    private EndpointNode getEndpointNode(String serviceName) throws ServiceException {
        Object service = this.findService(serviceName);
        EndpointNode node = (EndpointNode)this.endpoints.get(service);
        if (node == null) {
            throw new ServiceException(404, "service '" + serviceName + "' not found");
        }
        return node;
    }

    public Object findService(String name) throws ServiceException {
        List<Object> services = this.servicesByName.get(name);
        if (services == null || services.isEmpty()) {
            throw new ServiceException(404, "service '" + name + "' not found");
        }
        if (services.size() > 1) {
            Class<Object> clazz = SystemService.getServiceClass(services.get(0));
            Preconditions.checkState((boolean)name.equals(clazz.getSimpleName()), (Object)"Only requested simple class names should result in a collion.");
            StringBuilder builder = new StringBuilder("Two or more Endpoint classes are mapped to the same service name (").append(name).append("):");
            for (Object service : services) {
                builder.append(' ').append(SystemService.getServiceClass(service).getName());
            }
            throw new ServiceException(500, builder.toString());
        }
        Object service = services.get(0);
        logger.log(Level.FINE, "{0} => {1}", new Object[]{name, services.get(0)});
        return service;
    }

    public Method findServiceMethod(Object service, String methodName) throws ServiceException {
        EndpointMethod method;
        EndpointNode endpointNode;
        EndpointNode endpointNode2 = endpointNode = service == null ? null : (EndpointNode)this.endpoints.get(service);
        if (endpointNode != null && (method = endpointNode.methods.get(methodName)) != null) {
            logger.log(Level.FINE, "serviceMethod={0}", method.getMethod());
            return method.getMethod();
        }
        throw new ServiceException(404, "method '" + service + "." + methodName + "' not found");
    }

    public void invokeServiceMethod(Object service, Method method, ParamReader paramReader, ResultWriter resultWriter) throws IOException {
        Object response;
        Object[] params;
        try {
            params = paramReader.read();
            logger.log(Level.FINE, "params={0} (String)", Arrays.toString(params));
        }
        catch (BadRequestException e) {
            resultWriter.writeError(e);
            return;
        }
        try {
            response = method.invoke(service, params);
        }
        catch (IllegalArgumentException e) {
            resultWriter.writeError(new BadRequestException(e));
            return;
        }
        catch (IllegalAccessException e) {
            resultWriter.writeError(new BadRequestException(e));
            return;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            logger.log(Level.INFO, "cause={0}", cause);
            if (cause instanceof ServiceException) {
                resultWriter.writeError((ServiceException)cause);
            } else if (cause instanceof IllegalArgumentException) {
                resultWriter.writeError(new BadRequestException(cause));
            } else if (cause instanceof OAuthRequestException) {
                resultWriter.writeError(new UnauthorizedException(cause));
            } else if (cause.getCause() != null && cause.getCause() instanceof ServiceException) {
                cause = cause.getCause();
                resultWriter.writeError((ServiceException)cause);
            } else {
                logger.log(Level.SEVERE, cause.getMessage(), cause);
                resultWriter.writeError(new InternalServerErrorException(cause));
            }
            return;
        }
        resultWriter.write(response);
    }

    public Map<ApiKey, String> getApiConfigs() throws ApiConfigException {
        return this.configWriter.writeConfig((Iterable<? extends ApiConfig>)FluentIterable.from(this.endpoints.values()).transform(ENDPOINT_NODE_TO_API_CONFIG).filter(NON_INTERNAL_PREDICATE));
    }

    private static <T> Class<? super T> getServiceClass(T service) {
        Class<?> clazz = service.getClass();
        Enhancers[] enhancers = Enhancers.values();
        for (int i = 0; i < enhancers.length; ++i) {
            if (!enhancers[i].matches(clazz)) continue;
            clazz = clazz.getSuperclass();
            i = 0;
        }
        return clazz;
    }

    private static enum Enhancers {
        GUICE("$$EnhancerByGuice$$"),
        NONE(null);

        private final String enhancerSubstring;

        private Enhancers(String enhancerSubstring) {
            this.enhancerSubstring = enhancerSubstring;
        }

        public boolean matches(Class<?> clazz) {
            return this.enhancerSubstring != null && clazz.getSimpleName().contains(this.enhancerSubstring);
        }
    }

    private static class EndpointNode {
        public final Object endpoint;
        public final ApiConfig config;
        public final Map<String, EndpointMethod> methods;

        public EndpointNode(Object endpoint, ApiConfig config) {
            this.endpoint = endpoint;
            this.config = config;
            this.methods = new HashMap<String, EndpointMethod>();
        }
    }
}

