/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi;

import com.google.appengine.repackaged.com.google.common.reflect.TypeToken;
import java.lang.annotation.Annotation;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class TypeLoader {
    private final Map<String, Class<?>> classTypes;
    private final Map<Class<?>, String> parameterTypes;
    private final Map<Class<?>, String> schemaTypes;
    private final Map<Class<?>, String> schemaFormats;
    private final Map<String, Class<? extends Annotation>> annotationTypes;
    private final Set<Class<?>> injectedClassTypes;

    public TypeLoader() throws ClassNotFoundException {
        this(TypeLoader.class.getClassLoader());
    }

    public TypeLoader(ClassLoader classLoader) throws ClassNotFoundException {
        this.classTypes = TypeLoader.createClassTypes(classLoader);
        this.parameterTypes = TypeLoader.createParameterTypes(classLoader);
        this.schemaTypes = TypeLoader.createSchemaTypes(classLoader);
        this.schemaFormats = this.createSchemaFormats(classLoader);
        this.annotationTypes = TypeLoader.createAnnotationTypes(classLoader);
        this.injectedClassTypes = this.createInjectedClassTypes(classLoader);
    }

    private static Map<String, Class<?>> createClassTypes(ClassLoader classLoader) throws ClassNotFoundException {
        HashMap classTypes = new HashMap();
        classTypes.put("HttpServletRequest", classLoader.loadClass("javax.servlet.http.HttpServletRequest"));
        classTypes.put("User", classLoader.loadClass("com.google.appengine.api.users.User"));
        classTypes.put("Collection", classLoader.loadClass("java.util.Collection"));
        classTypes.put("Map", classLoader.loadClass("java.util.Map"));
        classTypes.put("CollectionResponses", classLoader.loadClass("com.google.api.server.spi.response.CollectionResponse"));
        return Collections.unmodifiableMap(classTypes);
    }

    private static Map<Class<?>, String> createParameterTypes(ClassLoader classLoader) throws ClassNotFoundException {
        HashMap parameterTypes = new HashMap();
        parameterTypes.put(classLoader.loadClass("java.lang.String"), "string");
        parameterTypes.put(classLoader.loadClass("java.lang.Boolean"), "boolean");
        parameterTypes.put(Boolean.TYPE, "boolean");
        parameterTypes.put(classLoader.loadClass("java.lang.Integer"), "int32");
        parameterTypes.put(Integer.TYPE, "int32");
        parameterTypes.put(classLoader.loadClass("java.lang.Long"), "int64");
        parameterTypes.put(Long.TYPE, "int64");
        parameterTypes.put(classLoader.loadClass("java.lang.Float"), "float");
        parameterTypes.put(Float.TYPE, "float");
        parameterTypes.put(classLoader.loadClass("java.lang.Double"), "double");
        parameterTypes.put(Double.TYPE, "double");
        parameterTypes.put(classLoader.loadClass("java.util.Date"), "datetime");
        parameterTypes.put(classLoader.loadClass("com.google.api.server.spi.types.DateAndTime"), "datetime");
        parameterTypes.put(classLoader.loadClass("com.google.api.server.spi.types.SimpleDate"), "date");
        return Collections.unmodifiableMap(parameterTypes);
    }

    private static Map<Class<?>, String> createSchemaTypes(ClassLoader classLoader) throws ClassNotFoundException {
        HashMap schemaTypes = new HashMap();
        schemaTypes.put(classLoader.loadClass("java.lang.String"), "string");
        schemaTypes.put(classLoader.loadClass("java.lang.Short"), "integer");
        schemaTypes.put(Short.TYPE, "integer");
        schemaTypes.put(classLoader.loadClass("java.lang.Byte"), "integer");
        schemaTypes.put(Byte.TYPE, "integer");
        schemaTypes.put(classLoader.loadClass("java.lang.Character"), "string");
        schemaTypes.put(Character.TYPE, "string");
        schemaTypes.put(classLoader.loadClass("java.lang.Integer"), "integer");
        schemaTypes.put(Integer.TYPE, "integer");
        schemaTypes.put(classLoader.loadClass("java.lang.Long"), "string");
        schemaTypes.put(Long.TYPE, "string");
        schemaTypes.put(classLoader.loadClass("java.lang.Float"), "number");
        schemaTypes.put(Float.TYPE, "number");
        schemaTypes.put(classLoader.loadClass("java.lang.Double"), "number");
        schemaTypes.put(Double.TYPE, "number");
        schemaTypes.put(classLoader.loadClass("java.lang.Boolean"), "boolean");
        schemaTypes.put(Boolean.TYPE, "boolean");
        schemaTypes.put(classLoader.loadClass("java.util.Date"), "string");
        schemaTypes.put(classLoader.loadClass("com.google.api.server.spi.types.DateAndTime"), "string");
        schemaTypes.put(classLoader.loadClass("com.google.api.server.spi.types.SimpleDate"), "string");
        schemaTypes.put(byte[].class, "string");
        schemaTypes.put(classLoader.loadClass("com.google.appengine.api.datastore.Blob"), "string");
        return Collections.unmodifiableMap(schemaTypes);
    }

    private Map<Class<?>, String> createSchemaFormats(ClassLoader classLoader) throws ClassNotFoundException {
        HashMap schemaFormats = new HashMap();
        schemaFormats.put(classLoader.loadClass("java.lang.Long"), "int64");
        schemaFormats.put(Long.TYPE, "int64");
        schemaFormats.put(classLoader.loadClass("java.lang.Float"), "float");
        schemaFormats.put(Float.TYPE, "float");
        schemaFormats.put(classLoader.loadClass("java.util.Date"), "date-time");
        schemaFormats.put(classLoader.loadClass("com.google.api.server.spi.types.DateAndTime"), "date-time");
        schemaFormats.put(classLoader.loadClass("com.google.api.server.spi.types.SimpleDate"), "date");
        schemaFormats.put(byte[].class, "byte");
        schemaFormats.put(classLoader.loadClass("com.google.appengine.api.datastore.Blob"), "byte");
        return Collections.unmodifiableMap(schemaFormats);
    }

    private static Map<String, Class<? extends Annotation>> createAnnotationTypes(ClassLoader classLoader) throws ClassNotFoundException {
        HashMap<String, Class<? extends Annotation>> annotationTypes = new HashMap<String, Class<? extends Annotation>>();
        annotationTypes.put("Api", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.Api"));
        annotationTypes.put("ApiReference", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiReference"));
        annotationTypes.put("ApiClass", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiClass"));
        annotationTypes.put("ApiMethod", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiMethod"));
        annotationTypes.put("ApiAuth", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiAuth"));
        annotationTypes.put("ApiFrontendLimits", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiFrontendLimits"));
        annotationTypes.put("ApiFrontendLimitRule", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiFrontendLimitRule"));
        annotationTypes.put("ApiCacheControl", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiCacheControl"));
        annotationTypes.put("ApiNamespace", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiNamespace"));
        annotationTypes.put("ApiTransformer", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.ApiTransformer"));
        annotationTypes.put("DefaultValue", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.DefaultValue"));
        annotationTypes.put("Named", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.Named"));
        annotationTypes.put("Nullable", TypeLoader.loadAnnotation(classLoader, "com.google.api.server.spi.config.Nullable"));
        return Collections.unmodifiableMap(annotationTypes);
    }

    private static Class<? extends Annotation> loadAnnotation(ClassLoader classLoader, String fullClassName) throws ClassNotFoundException {
        return classLoader.loadClass(fullClassName);
    }

    private Set<Class<?>> createInjectedClassTypes(ClassLoader classLoader) throws ClassNotFoundException {
        HashSet injectedClassTypes = new HashSet();
        injectedClassTypes.add(classLoader.loadClass("com.google.appengine.api.users.User"));
        injectedClassTypes.add(classLoader.loadClass("javax.servlet.http.HttpServletRequest"));
        injectedClassTypes.add(classLoader.loadClass("javax.servlet.ServletContext"));
        return Collections.unmodifiableSet(injectedClassTypes);
    }

    public static Type getArrayItemType(Type type) {
        if (type instanceof ParameterizedType) {
            Class classType;
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawParameterizedType = parameterizedType.getRawType();
            if (rawParameterizedType instanceof Class && Collection.class.isAssignableFrom(classType = (Class)rawParameterizedType)) {
                Type[] typeArgs = parameterizedType.getActualTypeArguments();
                return typeArgs.length > 0 ? typeArgs[0] : null;
            }
        } else {
            if (type instanceof GenericArrayType) {
                return ((GenericArrayType)type).getGenericComponentType();
            }
            if (type instanceof Class) {
                return ((Class)type).getComponentType();
            }
        }
        return null;
    }

    public Map<String, Class<?>> getClassTypes() {
        return this.classTypes;
    }

    public Map<Class<?>, String> getParameterTypes() {
        return this.parameterTypes;
    }

    public Map<Class<?>, String> getSchemaTypes() {
        return this.schemaTypes;
    }

    public Map<Class<?>, String> getSchemaFormats() {
        return this.schemaFormats;
    }

    public Map<String, Class<? extends Annotation>> getAnnotationTypes() {
        return this.annotationTypes;
    }

    public boolean isInjectedType(Type type) {
        return this.injectedClassTypes.contains(type);
    }

    public boolean isSchemaType(Type type) {
        return this.schemaTypes.containsKey(type);
    }

    public boolean isParameterType(Type type) {
        return this.parameterTypes.containsKey(type);
    }

    public static boolean isArrayType(Type type) {
        return TypeLoader.getArrayItemType(type) != null && type != byte[].class;
    }

    public static boolean isEnumType(Type enumType) {
        return TypeToken.of(enumType).getRawType().isEnum();
    }

    public boolean isMapType(Type collectionType) {
        return TypeToken.of(this.classTypes.get("Map")).isAssignableFrom(collectionType);
    }

    public static boolean isGenericType(Type type) {
        return type instanceof TypeVariable;
    }
}

