/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.server.spi.config;

import com.google.api.server.spi.EndpointMethod;
import com.google.api.server.spi.TypeLoader;
import com.google.api.server.spi.config.ApiConfig;
import com.google.api.server.spi.config.ApiMethodConfig;
import com.google.api.server.spi.config.AuthLevel;
import com.google.appengine.repackaged.com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ApiClassConfig {
    private final ApiConfig apiConfig;
    private final String apiClassJavaName;
    private final String apiClassJavaSimpleName;
    private final TypeLoader typeLoader;
    private String resource;
    private Boolean useDatastore;
    private AuthLevel authLevel;
    private List<String> scopes;
    private List<String> audiences;
    private List<String> clientIds;
    private final MethodConfigMap methods;

    public ApiClassConfig(ApiConfig apiConfig, TypeLoader typeLoader, Class<?> apiClass) {
        this.apiConfig = apiConfig;
        this.apiClassJavaName = apiClass.getName();
        this.apiClassJavaSimpleName = apiClass.getSimpleName();
        this.typeLoader = typeLoader;
        this.resource = null;
        this.authLevel = AuthLevel.UNSPECIFIED;
        this.scopes = null;
        this.audiences = null;
        this.clientIds = null;
        this.useDatastore = null;
        this.methods = new MethodConfigMap(this);
    }

    public ApiClassConfig(ApiClassConfig original, ApiConfig apiConfig) {
        this.apiConfig = apiConfig;
        this.apiClassJavaName = original.apiClassJavaName;
        this.apiClassJavaSimpleName = original.apiClassJavaSimpleName;
        this.typeLoader = original.typeLoader;
        this.resource = original.resource;
        this.authLevel = original.authLevel;
        this.scopes = original.scopes == null ? null : new ArrayList<String>(original.scopes);
        this.audiences = original.audiences == null ? null : new ArrayList<String>(original.audiences);
        this.clientIds = original.clientIds == null ? null : new ArrayList<String>(original.clientIds);
        this.useDatastore = original.useDatastore;
        this.methods = new MethodConfigMap(original.methods, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ApiClassConfig) {
            ApiClassConfig config = (ApiClassConfig)o;
            return Objects.equal((Object)this.apiClassJavaName, (Object)config.apiClassJavaName) && Objects.equal((Object)this.apiClassJavaSimpleName, (Object)config.apiClassJavaSimpleName) && Objects.equal((Object)this.typeLoader, (Object)config.typeLoader) && Objects.equal((Object)this.resource, (Object)config.resource) && Objects.equal((Object)((Object)this.authLevel), (Object)((Object)config.authLevel)) && Objects.equal(this.scopes, config.scopes) && Objects.equal(this.audiences, config.audiences) && Objects.equal(this.clientIds, config.clientIds) && Objects.equal((Object)this.useDatastore, (Object)config.useDatastore) && this.methods.equals(config.methods);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.apiClassJavaName, this.apiClassJavaSimpleName, this.typeLoader, this.resource, this.authLevel, this.scopes, this.audiences, this.clientIds, this.useDatastore, this.methods});
    }

    public ApiConfig getApiConfig() {
        return this.apiConfig;
    }

    public String getApiClassJavaName() {
        return this.apiClassJavaName;
    }

    public String getApiClassJavaSimpleName() {
        return this.apiClassJavaSimpleName;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public String getResource() {
        return this.resource != null ? this.resource : this.apiConfig.getResource();
    }

    public void setAuthLevel(AuthLevel authLevel) {
        this.authLevel = authLevel;
    }

    public AuthLevel getAuthLevel() {
        return this.authLevel != AuthLevel.UNSPECIFIED ? this.authLevel : this.apiConfig.getAuthLevel();
    }

    public void setScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public List<String> getScopes() {
        return this.scopes != null ? this.scopes : this.apiConfig.getScopes();
    }

    public void setAudiences(List<String> audiences) {
        this.audiences = audiences;
    }

    public List<String> getAudiences() {
        return this.audiences != null ? this.audiences : this.apiConfig.getAudiences();
    }

    public void setClientIds(List<String> clientIds) {
        this.clientIds = clientIds;
    }

    public List<String> getClientIds() {
        return this.clientIds != null ? this.clientIds : this.apiConfig.getClientIds();
    }

    public void setUseDatastore(boolean useDatastore) {
        this.useDatastore = useDatastore;
    }

    public boolean getUseDatastore() {
        return this.useDatastore != null ? this.useDatastore.booleanValue() : this.apiConfig.getUseDatastore();
    }

    public MethodConfigMap getMethods() {
        return this.methods;
    }

    public static class MethodConfigMap
    extends HashMap<EndpointMethod, ApiMethodConfig> {
        private final ApiClassConfig apiClassConfig;

        protected MethodConfigMap(ApiClassConfig apiClassConfig) {
            this.apiClassConfig = apiClassConfig;
        }

        protected MethodConfigMap(MethodConfigMap original, ApiClassConfig apiClassConfig) {
            this.apiClassConfig = apiClassConfig;
            for (Map.Entry entry : original.entrySet()) {
                this.put(entry.getKey(), new ApiMethodConfig((ApiMethodConfig)entry.getValue(), apiClassConfig));
            }
        }

        public ApiMethodConfig getOrCreate(EndpointMethod method) {
            if (this.containsKey(method)) {
                return (ApiMethodConfig)this.get(method);
            }
            ApiMethodConfig methodConfig = this.createMethodConfig(method, this.apiClassConfig.typeLoader, this.apiClassConfig);
            this.put(method, methodConfig);
            return methodConfig;
        }

        protected ApiMethodConfig createMethodConfig(EndpointMethod method, TypeLoader typeLoader, ApiClassConfig apiClassConfig) {
            return new ApiMethodConfig(method, typeLoader, apiClassConfig);
        }

        public ApiClassConfig getApiClassConfig() {
            return this.apiClassConfig;
        }
    }
}

