/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.Category;
import com.google.appengine.api.datastore.Email;
import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.GeoPt;
import com.google.appengine.api.datastore.IMHandle;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Link;
import com.google.appengine.api.datastore.PhoneNumber;
import com.google.appengine.api.datastore.PostalAddress;
import com.google.appengine.api.datastore.Rating;
import com.google.appengine.api.datastore.RawValue;
import com.google.appengine.api.datastore.ShortBlob;
import com.google.appengine.api.datastore.Text;
import com.google.appengine.api.users.User;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public final class DataTypeUtils {
    private static final Logger logger = Logger.getLogger(DataTypeUtils.class.getName());
    public static final int MAX_STRING_PROPERTY_LENGTH = 500;
    public static final int MAX_SHORT_BLOB_PROPERTY_LENGTH = 500;
    public static final int MAX_LINK_PROPERTY_LENGTH = 2038;
    private static final Set<Class<?>> SUPPORTED_TYPES = new HashSet();

    public static void checkSupportedValue(Object value) {
        DataTypeUtils.checkSupportedValue(null, value);
    }

    public static void checkSupportedValue(String name, Object value) {
        DataTypeUtils.checkSupportedValue(name, value, true, false);
    }

    static void checkSupportedValue(String name, Object value, boolean allowMultiValue, boolean requireMultiValue) {
        EnumSet<CheckValueOption> options = EnumSet.noneOf(CheckValueOption.class);
        if (allowMultiValue) {
            options.add(CheckValueOption.ALLOW_MULTI_VALUE);
        }
        if (requireMultiValue) {
            options.add(CheckValueOption.REQUIRE_MULTI_VALUE);
        }
        DataTypeUtils.checkSupportedValue(name, value, options, SUPPORTED_TYPES);
    }

    static void checkSupportedValue(String name, Object value, EnumSet<CheckValueOption> options, Set<Class<?>> supportedTypes) {
        if (value instanceof Collection) {
            if (!options.contains((Object)CheckValueOption.ALLOW_MULTI_VALUE)) {
                throw new IllegalArgumentException("A collection of values is not allowed.");
            }
            Collection values = (Collection)value;
            if (!values.isEmpty()) {
                for (Object obj : values) {
                    DataTypeUtils.checkSupportedSingleValue(name, obj, options, supportedTypes);
                }
            } else if (options.contains((Object)CheckValueOption.REQUIRE_MULTI_VALUE)) {
                throw new IllegalArgumentException("A collection with at least one value is required.");
            }
        } else {
            if (options.contains((Object)CheckValueOption.REQUIRE_MULTI_VALUE)) {
                throw new IllegalArgumentException("A collection of values is required.");
            }
            DataTypeUtils.checkSupportedSingleValue(name, value, options, supportedTypes);
        }
    }

    private static void checkSupportedSingleValue(String name, Object value, EnumSet<CheckValueOption> options, Set<Class<?>> supportedTypes) {
        int length;
        if (value == null) {
            return;
        }
        if ("__key__".equals(name) && !(value instanceof Key)) {
            logger.warning("__key__ value should be of type Key");
        }
        if (options.contains((Object)CheckValueOption.VALUE_PRE_CHECKED_WITHOUT_NAME)) {
            return;
        }
        String prefix = name == null ? "" : name + ": ";
        if (!supportedTypes.contains(value.getClass())) {
            throw new IllegalArgumentException(prefix + value.getClass().getName() + " is not a supported property type.");
        }
        if (value instanceof String) {
            int length2 = ((String)value).length();
            if (length2 > 500) {
                throw new IllegalArgumentException(prefix + "String properties must be " + 500 + " characters or less.  Instead, use " + Text.class.getName() + ", which can store " + "strings of any length.");
            }
        } else if (value instanceof Link) {
            int length3 = ((Link)value).getValue().length();
            if (length3 > 2038) {
                throw new IllegalArgumentException(prefix + "Link properties must be " + 2038 + " characters or less.  Instead, use " + Text.class.getName() + ", which can store " + "strings of any length.");
            }
        } else if (value instanceof ShortBlob && (length = ((ShortBlob)value).getBytes().length) > 500) {
            throw new IllegalArgumentException(prefix + "byte[] properties must be " + 500 + " bytes or less.  Instead, use " + Blob.class.getName() + ", which can store binary " + "data of any size.");
        }
    }

    public static boolean isSupportedType(Class<?> clazz) {
        return SUPPORTED_TYPES.contains(clazz);
    }

    public static Set<Class<?>> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    private DataTypeUtils() {
    }

    static {
        SUPPORTED_TYPES.add(RawValue.class);
        SUPPORTED_TYPES.add(Boolean.class);
        SUPPORTED_TYPES.add(String.class);
        SUPPORTED_TYPES.add(Byte.class);
        SUPPORTED_TYPES.add(Short.class);
        SUPPORTED_TYPES.add(Integer.class);
        SUPPORTED_TYPES.add(Long.class);
        SUPPORTED_TYPES.add(Float.class);
        SUPPORTED_TYPES.add(Double.class);
        SUPPORTED_TYPES.add(User.class);
        SUPPORTED_TYPES.add(Key.class);
        SUPPORTED_TYPES.add(Blob.class);
        SUPPORTED_TYPES.add(Text.class);
        SUPPORTED_TYPES.add(Date.class);
        SUPPORTED_TYPES.add(Link.class);
        SUPPORTED_TYPES.add(ShortBlob.class);
        SUPPORTED_TYPES.add(GeoPt.class);
        SUPPORTED_TYPES.add(Category.class);
        SUPPORTED_TYPES.add(Rating.class);
        SUPPORTED_TYPES.add(PhoneNumber.class);
        SUPPORTED_TYPES.add(PostalAddress.class);
        SUPPORTED_TYPES.add(Email.class);
        SUPPORTED_TYPES.add(IMHandle.class);
        SUPPORTED_TYPES.add(BlobKey.class);
        SUPPORTED_TYPES.add(EmbeddedEntity.class);
    }

    static enum CheckValueOption {
        ALLOW_MULTI_VALUE,
        REQUIRE_MULTI_VALUE,
        VALUE_PRE_CHECKED_WITHOUT_NAME;

    }
}

