/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Blob;
import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.appengine.api.datastore.EmbeddedEntity;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Text;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class PropertyContainer
implements Serializable,
Cloneable {
    static final Pattern RESERVED_NAME = Pattern.compile("^__.*__$");

    PropertyContainer() {
    }

    public Object getProperty(String propertyName) {
        return PropertyContainer.unwrapValue(this.getPropertyMap().get(propertyName));
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>(this.getPropertyMap().size());
        for (Map.Entry<String, Object> entry : this.getPropertyMap().entrySet()) {
            properties.put(entry.getKey(), PropertyContainer.unwrapValue(entry.getValue()));
        }
        return Collections.unmodifiableMap(properties);
    }

    public boolean hasProperty(String propertyName) {
        return this.getPropertyMap().containsKey(propertyName);
    }

    public void removeProperty(String propertyName) {
        this.getPropertyMap().remove(propertyName);
    }

    public void setProperty(String propertyName, Object value) {
        DataTypeUtils.checkSupportedValue(propertyName, value);
        this.getPropertyMap().put(propertyName, value);
    }

    public void setUnindexedProperty(String propertyName, Object value) {
        DataTypeUtils.checkSupportedValue(propertyName, value);
        this.getPropertyMap().put(propertyName, new Entity.UnindexedValue(value));
    }

    public boolean isUnindexedProperty(String propertyName) {
        Object value = this.getPropertyMap().get(propertyName);
        return value instanceof Entity.UnindexedValue || value instanceof Text || value instanceof Blob || value instanceof EmbeddedEntity;
    }

    public void setPropertiesFrom(PropertyContainer src) {
        for (Map.Entry<String, Object> entry : src.getPropertyMap().entrySet()) {
            String name = entry.getKey();
            Object entryValue = entry.getValue();
            boolean indexed = entryValue instanceof Entity.UnindexedValue;
            ArrayList<Object> valueToAdd = PropertyContainer.unwrapValue(entryValue);
            if (valueToAdd instanceof Collection) {
                ArrayList<Object> destColl;
                Collection srcColl = valueToAdd;
                valueToAdd = destColl = new ArrayList<Object>(srcColl.size());
                for (Object element : srcColl) {
                    destColl.add(PropertyContainer.cloneIfMutable(element));
                }
            } else {
                valueToAdd = PropertyContainer.cloneIfMutable(valueToAdd);
            }
            if (indexed) {
                valueToAdd = new Entity.UnindexedValue(valueToAdd);
            }
            this.getPropertyMap().put(name, valueToAdd);
        }
    }

    abstract Map<String, Object> getPropertyMap();

    static Object unwrapValue(Object obj) {
        if (obj instanceof Entity.UnindexedValue) {
            return ((Entity.UnindexedValue)obj).getValue();
        }
        return obj;
    }

    protected Object clone() {
        throw new UnsupportedOperationException();
    }

    private static Object cloneIfMutable(Object obj) {
        if (obj instanceof Date) {
            return ((Date)obj).clone();
        }
        if (obj instanceof PropertyContainer) {
            return ((PropertyContainer)obj).clone();
        }
        return obj;
    }

    protected void appendPropertiesTo(StringBuilder builder) {
        for (Map.Entry<String, Object> entry : this.getPropertyMap().entrySet()) {
            builder.append('\t').append(entry.getKey()).append(" = ").append(entry.getValue()).append('\n');
        }
    }
}

