/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Suppliers;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.io.protocol.ExtendableProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.MessageVisitor;
import com.google.appengine.repackaged.com.google.io.protocol.MutableBridge;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolSupport;
import com.google.appengine.repackaged.com.google.io.protocol.proto.ProtocolDescriptor;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.CodedInputStream;
import com.google.appengine.repackaged.com.google.protobuf.CodedOutputStream;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class ProtocolType {
    private final Class<? extends ProtocolMessage> clazz;
    private final FieldType[] fields;
    private final SortedMap<Integer, FieldType> tagsByNumber = new TreeMap<Integer, FieldType>();
    private final SortedMap<String, FieldType> tagsByPrintName = new TreeMap<String, FieldType>();
    private Supplier<String> protocolDescriptorStringSupplier;
    private Supplier<ProtocolDescriptor> protocolDescriptorSupplier;
    private ProtocolDescriptor protocolDescriptor;
    private PropertyDescriptor[] propertyDescriptors;
    private boolean havePropertyDescriptors;

    public ProtocolType(Class<? extends ProtocolMessage> myClass, String encodedProtocolDescriptor, FieldType ... fields) {
        this(myClass, Suppliers.ofInstance(encodedProtocolDescriptor), null, fields);
    }

    public static ProtocolType newProtocolType(Class<? extends ProtocolMessage> myClass, Supplier<String> encodedProtocolDescriptor, FieldType ... fields) {
        return new ProtocolType(myClass, encodedProtocolDescriptor, null, fields);
    }

    public static ProtocolType newProtocolType(Class<? extends ProtocolMessage> myClass, String encodedProtocolDescriptor, FieldType ... fields) {
        return new ProtocolType(myClass, encodedProtocolDescriptor, fields);
    }

    public static ProtocolType newProtocolType(Class<? extends MutableBridge.AbstractDowngradedMessage> myClass, final Descriptors.Descriptor descriptor, FieldType ... fields) {
        Supplier<ProtocolDescriptor> downgraded = new Supplier<ProtocolDescriptor>(){

            @Override
            public ProtocolDescriptor get() {
                return MutableBridge.DescriptorDowngrader.downgrade(descriptor);
            }
        };
        return new ProtocolType(myClass, null, downgraded, fields);
    }

    private ProtocolType(Class<? extends ProtocolMessage> myClass, Supplier<String> encodedProtocolDescriptor, Supplier<ProtocolDescriptor> protocolDescriptor, FieldType ... fields) {
        this.clazz = myClass;
        this.fields = fields;
        for (FieldType ti : fields) {
            this.tagsByNumber.put(ti.tag, ti);
            this.tagsByPrintName.put(ti.printName, ti);
        }
        for (FieldType ti : fields) {
            if (ti.getContainingApiType() == ApiType.PROTO2) continue;
            try {
                String base = ti.internalName + "_";
                ti.dataField = myClass.getDeclaredField(base);
                ti.dataField.setAccessible(true);
                switch (ti.presence) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        if (ti.bitTag == Integer.MIN_VALUE) {
                            ti.sizeField = myClass.getDeclaredField("has_" + base);
                        } else {
                            String varName = "optional_" + (ti.bitTag >> 5) + "_";
                            ti.sizeField = myClass.getDeclaredField(varName);
                        }
                        ti.sizeField.setAccessible(true);
                        break;
                    }
                    case REPEATED: {
                        if (!ti.baseType.isScalar()) break;
                        ti.sizeField = myClass.getDeclaredField(base + "elts_");
                        ti.sizeField.setAccessible(true);
                    }
                }
            }
            catch (NoSuchFieldException e) {
                throw new AssertionError((Object)("Error on field: " + ti));
            }
        }
        this.protocolDescriptorStringSupplier = encodedProtocolDescriptor;
        this.protocolDescriptorSupplier = protocolDescriptor;
    }

    public static void visit(ProtocolMessage message, Visitor visitor) {
        ProtocolType protocolType = message.getProtocolType();
        List<FieldType> fields = Arrays.asList(protocolType.fields);
        protocolType.visitInternal(message, visitor, fields);
    }

    public static void visitInTagOrder(ProtocolMessage message, Visitor visitor) {
        ProtocolType protocolType = message.getProtocolType();
        Collection<FieldType> fields = protocolType.tagsByNumber.values();
        protocolType.visitInternal(message, visitor, fields);
    }

    public static void visit(ProtocolMessage message, MessageVisitor visitor) {
        ProtocolType protocolType = message.getProtocolType();
        List<FieldType> fields = Arrays.asList(protocolType.fields);
        protocolType.visitInternal(message, visitor, fields);
    }

    public static void visitInTagOrder(ProtocolMessage message, MessageVisitor visitor) {
        ProtocolType protocolType = message.getProtocolType();
        Collection<FieldType> fields = protocolType.tagsByNumber.values();
        protocolType.visitInternal(message, visitor, fields);
    }

    public static List<FieldType> getTags(ProtocolMessage message) {
        ProtocolType protocolType = message.getProtocolType();
        return Collections.unmodifiableList(Arrays.asList(protocolType.fields));
    }

    public static List<FieldType> getTags(Class<? extends ProtocolMessage> clazz) {
        while (clazz.getSuperclass() != ProtocolMessage.class && clazz.getSuperclass() != ExtendableProtocolMessage.class) {
            clazz = clazz.getSuperclass();
        }
        ProtocolType protocolType = ProtocolSupport.newInstance(clazz).getProtocolType();
        return Collections.unmodifiableList(Arrays.asList(protocolType.fields));
    }

    protected void visitInternal(ProtocolMessage message, Visitor visitor, Iterable<FieldType> fields) {
        for (FieldType fieldType : fields) {
            fieldType.visit(message, visitor);
        }
    }

    protected void visitInternal(ProtocolMessage message, MessageVisitor visitor, Iterable<FieldType> fields) {
        for (FieldType fieldType : fields) {
            fieldType.visit(message, visitor);
        }
    }

    public FieldType getTagInfo(int tag) {
        return (FieldType)this.tagsByNumber.get(tag);
    }

    public FieldType getTagInfo(String name) {
        return (FieldType)this.tagsByPrintName.get(name);
    }

    public Class<? extends ProtocolMessage> getProtocolMessageClass() {
        return this.clazz;
    }

    synchronized PropertyDescriptor[] getPropertyDescriptors() {
        if (!this.havePropertyDescriptors) {
            this.propertyDescriptors = ProtocolType.createPropertyDescriptors(this.clazz);
            this.havePropertyDescriptors = true;
        }
        return (PropertyDescriptor[])this.propertyDescriptors.clone();
    }

    private static PropertyDescriptor[] createPropertyDescriptors(Class<?> cls) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(cls, 2);
            HashMap<String, Object> propertiesByName = Maps.newHashMap();
            PropertyDescriptor[] properties = beanInfo.getPropertyDescriptors();
            if (properties != null) {
                for (PropertyDescriptor property : properties) {
                    propertiesByName.put(property.getName(), property);
                }
            }
            for (Method method : cls.getMethods()) {
                PropertyDescriptor descriptor;
                Class<?>[] argTypes;
                int argCount;
                if (!method.getName().startsWith("set") || !method.getReturnType().equals(cls)) continue;
                String propertyName = Introspector.decapitalize(method.getName().substring(3));
                PropertyDescriptor existing = (PropertyDescriptor)propertiesByName.get(propertyName);
                Method readMethod = null;
                if (existing != null) {
                    if (existing.getWriteMethod() != null) continue;
                    readMethod = existing.getReadMethod();
                }
                if ((argCount = (argTypes = method.getParameterTypes()).length) == 1 && argTypes[0] == readMethod.getReturnType()) {
                    descriptor = new PropertyDescriptor(propertyName, readMethod, method);
                } else {
                    if (argCount != 2 || argTypes[0] != Integer.TYPE) continue;
                    descriptor = new IndexedPropertyDescriptor(propertyName, null, null, readMethod, method);
                }
                propertiesByName.put(propertyName, descriptor);
            }
            return propertiesByName.values().toArray(new PropertyDescriptor[propertiesByName.size()]);
        }
        catch (IntrospectionException exception) {
            throw new IllegalStateException(exception);
        }
    }

    public synchronized ProtocolDescriptor getProtocolDescriptor() {
        if (this.protocolDescriptor == null) {
            if (this.protocolDescriptorSupplier != null) {
                this.protocolDescriptor = this.protocolDescriptorSupplier.get();
                this.protocolDescriptorSupplier = null;
                if (this.protocolDescriptor == null) {
                    throw new IllegalStateException("No protocol descriptor for downgraded messages.");
                }
                return this.fixProtocolDescriptor(this.protocolDescriptor);
            }
            if (this.protocolDescriptorStringSupplier == null || this.protocolDescriptorStringSupplier.get() == null) {
                throw new IllegalStateException("No protocol descriptor");
            }
            this.protocolDescriptor = this.decodeProtocolDescriptor(this.protocolDescriptorStringSupplier.get());
            this.protocolDescriptorStringSupplier = null;
        }
        return this.protocolDescriptor;
    }

    private ProtocolDescriptor decodeProtocolDescriptor(String encoding) {
        int size = encoding.length();
        byte[] bytes = new byte[size];
        encoding.getBytes(0, size, bytes, 0);
        ProtocolDescriptor result = new ProtocolDescriptor();
        if (!result.mergeFrom(bytes)) {
            throw new AssertionError((Object)"Bad ProtocolDescriptor");
        }
        return this.fixProtocolDescriptor(result);
    }

    @VisibleForTesting
    ProtocolDescriptor fixProtocolDescriptor(ProtocolDescriptor descriptor) {
        descriptor.setProtoName(descriptor.getName());
        descriptor.setName(this.clazz.getName());
        HashMap<Integer, ProtocolType> tagMap = Maps.newHashMap();
        tagMap.put(-1, this);
        for (int tagIndex = 0; tagIndex < descriptor.tagSize(); ++tagIndex) {
            ProtocolDescriptor.Tag tag = descriptor.getMutableTag(tagIndex);
            ProtocolDescriptor.DeclaredType declaredType = ProtocolDescriptor.DeclaredType.valueOf(tag.getDeclaredType());
            if (declaredType != ProtocolDescriptor.DeclaredType.TYPE_GROUP && declaredType != ProtocolDescriptor.DeclaredType.TYPE_FOREIGN) continue;
            int parentIndex = tag.hasParent() ? tag.getParent() : -1;
            ProtocolType parent = (ProtocolType)tagMap.get(parentIndex);
            FieldType tagInfo = parent.getTagInfo(tag.getNumber());
            if (declaredType == ProtocolDescriptor.DeclaredType.TYPE_GROUP) {
                Class<? extends ProtocolMessage> groupClass = tagInfo.getSubclass();
                ProtocolType subProtocolType = ProtocolSupport.newInstance(groupClass).getProtocolType();
                tagMap.put(tagIndex, subProtocolType);
                continue;
            }
            tag.setForeignProtoName(tag.getForeign());
            tag.setForeign(tagInfo.getSubclass().getName());
        }
        return descriptor;
    }

    public String toString() {
        return "<ProtocolType: " + this.clazz.getSimpleName() + ">";
    }

    static Object convertFromProto2Reflection(Descriptors.FieldDescriptor descriptor, Object value) {
        switch (descriptor.getType()) {
            case GROUP: 
            case MESSAGE: {
                return value;
            }
            case BOOL: 
            case FIXED32: 
            case SFIXED32: 
            case FIXED64: 
            case SFIXED64: 
            case INT32: 
            case INT64: 
            case UINT64: 
            case FLOAT: 
            case DOUBLE: {
                return value;
            }
            case STRING: {
                return ProtocolSupport.toBytesUtf8((String)value);
            }
            case BYTES: {
                return ((ByteString)value).toByteArray();
            }
            case UINT32: {
                return (long)((Integer)value).intValue();
            }
            case SINT32: {
                return CodedOutputStream.encodeZigZag64(((Integer)value).intValue());
            }
            case SINT64: {
                return CodedOutputStream.encodeZigZag64((Long)value);
            }
            case ENUM: {
                return ((Descriptors.EnumValueDescriptor)value).getNumber();
            }
        }
        throw new RuntimeException("Does not support type " + (Object)((Object)descriptor.getType()));
    }

    static Object convertToProto2Reflection(Descriptors.FieldDescriptor descriptor, Object value) {
        switch (descriptor.getType()) {
            case GROUP: 
            case MESSAGE: {
                return value;
            }
            case BOOL: 
            case FIXED32: 
            case SFIXED32: 
            case FIXED64: 
            case SFIXED64: 
            case INT32: 
            case INT64: 
            case UINT64: 
            case FLOAT: 
            case DOUBLE: {
                return value;
            }
            case STRING: {
                try {
                    return new String((byte[])value, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("Java VM does not support a standard character set.", e);
                }
            }
            case BYTES: {
                return ByteString.copyFrom((byte[])value);
            }
            case UINT32: {
                return (int)((Long)value).longValue();
            }
            case SINT32: {
                return CodedInputStream.decodeZigZag32((int)((Long)value).longValue());
            }
            case SINT64: {
                return CodedInputStream.decodeZigZag64((Long)value);
            }
            case ENUM: {
                Descriptors.EnumValueDescriptor converted = descriptor.getEnumType().findValueByNumber((Integer)value);
                if (converted == null) {
                    return descriptor.getEnumType().getValues().get(0);
                }
                return converted;
            }
        }
        throw new RuntimeException("Does not support type " + (Object)((Object)descriptor.getType()));
    }

    public static class Proto2ContainerFieldType
    extends FieldType {
        private final Descriptors.FieldDescriptor descriptor;

        private static Presence getPresence(Descriptors.FieldDescriptor descriptor) {
            Presence presence = descriptor.isRepeated() ? Presence.REPEATED : (descriptor.isRequired() ? Presence.REQUIRED : Presence.OPTIONAL);
            return presence;
        }

        private static FieldBaseType toFieldBaseType(Descriptors.FieldDescriptor.Type type) {
            FieldBaseType baseType;
            switch (type) {
                case BOOL: {
                    baseType = FieldBaseType.BOOL;
                    break;
                }
                case BYTES: 
                case STRING: {
                    baseType = FieldBaseType.STRING;
                    break;
                }
                case FIXED32: 
                case SFIXED32: {
                    baseType = FieldBaseType.FIXED32;
                    break;
                }
                case FIXED64: 
                case SFIXED64: {
                    baseType = FieldBaseType.FIXED64;
                    break;
                }
                case INT32: 
                case ENUM: {
                    baseType = FieldBaseType.INT32;
                    break;
                }
                case INT64: {
                    baseType = FieldBaseType.INT64;
                    break;
                }
                case SINT32: 
                case UINT32: 
                case SINT64: 
                case UINT64: {
                    baseType = FieldBaseType.UINT64;
                    break;
                }
                case FLOAT: {
                    baseType = FieldBaseType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    baseType = FieldBaseType.DOUBLE;
                    break;
                }
                case GROUP: {
                    baseType = FieldBaseType.GROUP;
                    break;
                }
                case MESSAGE: {
                    baseType = FieldBaseType.FOREIGN;
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported types. Should not reach here");
                }
            }
            return baseType;
        }

        private static String getPrintName(Descriptors.FieldDescriptor descriptor) {
            if (descriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                return descriptor.getMessageType().getName();
            }
            return descriptor.getName();
        }

        public static Proto2ContainerFieldType newFieldType(Descriptors.FieldDescriptor descriptor, Class<? extends ProtocolMessage> subclass, Class<? extends Enum> enumClass) {
            if (enumClass != null) {
                return new Proto2ContainerFieldType(descriptor, enumClass, false);
            }
            return new Proto2ContainerFieldType(descriptor, subclass);
        }

        private Proto2ContainerFieldType(Descriptors.FieldDescriptor descriptor, Class<? extends ProtocolMessage> subClass) {
            super(Proto2ContainerFieldType.getPrintName(descriptor), descriptor.getName().toLowerCase(), descriptor.getNumber(), Proto2ContainerFieldType.toFieldBaseType(descriptor.getType()), Proto2ContainerFieldType.getPresence(descriptor), subClass);
            this.descriptor = descriptor;
        }

        private Proto2ContainerFieldType(Descriptors.FieldDescriptor descriptor, Class<? extends Enum> enumClass, boolean unused) {
            super(Proto2ContainerFieldType.getPrintName(descriptor), descriptor.getName().toLowerCase(), descriptor.getNumber(), Proto2ContainerFieldType.getPresence(descriptor), enumClass);
            this.descriptor = descriptor;
        }

        @Override
        public ApiType getContainingApiType() {
            return ApiType.PROTO2;
        }

        @Override
        public ApiType getForeignApiType() {
            if (this.descriptor.isProto1FieldInMutableApi()) {
                return ApiType.PROTO1;
            }
            return ApiType.PROTO2;
        }

        @Override
        protected Object coerceReturnType(Object value) {
            if (this.descriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE || this.descriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                return super.coerceReturnType(value);
            }
            return ProtocolType.convertFromProto2Reflection(this.descriptor, value);
        }

        @Override
        protected Object coerceSetterType(Object value) {
            if (this.descriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE || this.descriptor.getType() == Descriptors.FieldDescriptor.Type.GROUP) {
                return super.coerceSetterType(value);
            }
            return ProtocolType.convertToProto2Reflection(this.descriptor, value);
        }

        @Override
        public int size(ProtocolMessage object) {
            if (this.descriptor.isRepeated()) {
                return object.getRepeatedFieldCount(this.descriptor);
            }
            return object.hasField(this.descriptor) ? 1 : 0;
        }

        @Override
        public Object getSingleValue(ProtocolMessage message) {
            if (this.descriptor.isRepeated()) {
                throw new IllegalArgumentException("Cannot call getSingleValue() on repeated field: " + this.descriptor.getFullName());
            }
            if (!(this.descriptor.getType() != Descriptors.FieldDescriptor.Type.MESSAGE && this.descriptor.getType() != Descriptors.FieldDescriptor.Type.GROUP || message.hasField(this.descriptor))) {
                return null;
            }
            return this.coerceReturnType(message.getField(this.descriptor));
        }

        @Override
        public Object getNthValue(ProtocolMessage message, int index) {
            return this.coerceReturnType(message.getRepeatedField(this.descriptor, index));
        }

        @Override
        public void setNthValue(ProtocolMessage message, int index, Object elem) {
            message.setRepeatedField(this.descriptor, index, this.coerceSetterType(elem));
        }

        @Override
        public void clear(ProtocolMessage message) {
            message.clearField(this.descriptor);
        }

        @Override
        public void setSingleValue(ProtocolMessage message, Object value) {
            if (this.descriptor.isRepeated()) {
                throw new IllegalArgumentException("Cannot call setSingleValue() on repeated field: " + this.descriptor.getFullName());
            }
            message.setField(this.descriptor, this.coerceSetterType(value));
        }

        @Override
        public void addValue(ProtocolMessage message, Object elem) {
            message.addRepeatedField(this.descriptor, this.coerceSetterType(elem));
        }
    }

    public static class FieldType {
        private static final int MISSING_BIT_INDEX = Integer.MIN_VALUE;
        private final String internalName;
        private final String printName;
        private final int tag;
        private final FieldBaseType baseType;
        private final Presence presence;
        @Nullable
        private final Class<? extends ProtocolMessage> subclass;
        private final ApiType foreignApiType;
        @Nullable
        private Class<? extends Enum> enumType;
        private Field dataField;
        private Field sizeField;
        private final int bitTag;
        private final Constructor<? extends ProtocolMessage> constructor;

        public FieldType(String externalName, String internalName, int wireTag, FieldBaseType declareType, Presence presence) {
            this(externalName, internalName, wireTag, Integer.MIN_VALUE, declareType, presence, null);
        }

        public FieldType(String externalName, String internalName, int wireTag, FieldBaseType declareType, Presence presence, Class<? extends ProtocolMessage> subclass) {
            this(externalName, internalName, wireTag, Integer.MIN_VALUE, declareType, presence, subclass);
        }

        public FieldType(String externalName, String internalName, int wireTag, Presence presence, Class<? extends Enum> enumType) {
            this(externalName, internalName, wireTag, Integer.MIN_VALUE, FieldBaseType.INT32, presence, null);
            this.enumType = enumType;
        }

        public FieldType(String externalName, String internalName, int wireTag, int bitTag, FieldBaseType declareType, Presence presence) {
            this(externalName, internalName, wireTag, bitTag, declareType, presence, null);
        }

        public FieldType(String externalName, String internalName, int wireTag, int bitTag, FieldBaseType declareType, Presence presence, Class<? extends ProtocolMessage> subclass) {
            this.internalName = internalName;
            this.printName = externalName;
            this.tag = wireTag;
            this.baseType = declareType;
            this.presence = presence;
            this.subclass = subclass;
            this.bitTag = bitTag;
            if (subclass != null && MutableBridge.AbstractDowngradedMessage.class.isAssignableFrom(subclass)) {
                this.foreignApiType = ApiType.PROTO2;
                try {
                    ParameterizedType superType = (ParameterizedType)subclass.getGenericSuperclass();
                    Class proto2Class = (Class)superType.getActualTypeArguments()[1];
                    this.constructor = subclass.getConstructor(proto2Class);
                }
                catch (Exception e) {
                    throw new RuntimeException("Generated downgraded message missing method", e);
                }
            } else {
                this.foreignApiType = ApiType.PROTO1;
                this.constructor = null;
            }
        }

        public FieldType(String externalName, String internalName, int wireTag, int bitTab, Presence presence, Class<? extends Enum> enumType) {
            this(externalName, internalName, wireTag, bitTab, FieldBaseType.INT32, presence, null);
            this.enumType = enumType;
        }

        protected Class<?> getParentClass() {
            return this.dataField.getDeclaringClass();
        }

        public String getCName() {
            return this.internalName;
        }

        public String getName() {
            return this.printName;
        }

        public int getTag() {
            return this.tag;
        }

        public int getWireTag() {
            return (this.tag << 3) + this.baseType.getWireType().getValue();
        }

        public FieldBaseType getBaseType() {
            return this.baseType;
        }

        public Presence getPresence() {
            return this.presence;
        }

        @Nullable
        public Class<? extends ProtocolMessage> getSubclass() {
            return this.subclass;
        }

        @Nullable
        public Class<? extends Enum> getEnumType() {
            return this.enumType;
        }

        public ApiType getForeignApiType() {
            return this.foreignApiType;
        }

        public ApiType getContainingApiType() {
            return ApiType.PROTO1;
        }

        public int size(ProtocolMessage object) {
            try {
                switch (this.presence) {
                    case REQUIRED: 
                    case OPTIONAL: {
                        if (this.bitTag == Integer.MIN_VALUE) {
                            return this.sizeField.getBoolean(object) ? 1 : 0;
                        }
                        int value = this.sizeField.getInt(object);
                        return (value & 1 << this.bitTag) != 0 ? 1 : 0;
                    }
                    case REPEATED: {
                        if (this.sizeField != null) {
                            return this.sizeField.getInt(object);
                        }
                        List value = (List)this.dataField.get(object);
                        return value != null ? value.size() : 0;
                    }
                }
                throw new AssertionError((Object)"Should not reach here");
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"Should not reach here");
            }
        }

        public void visit(ProtocolMessage message, Visitor visitor) {
            int size = this.size(message);
            if (!visitor.shouldVisitField(this, size)) {
                return;
            }
            block10: for (int index = 0; index < size; ++index) {
                Object value = this.presence == Presence.REPEATED ? this.getNthValue(message, index) : this.getSingleValue(message);
                switch (this.baseType) {
                    case BOOL: {
                        visitor.visitBoolean(this, index, (Boolean)value);
                        continue block10;
                    }
                    case INT32: 
                    case FIXED32: {
                        visitor.visitInteger(this, index, (Integer)value);
                        continue block10;
                    }
                    case INT64: 
                    case UINT64: 
                    case FIXED64: {
                        visitor.visitLong(this, index, (Long)value);
                        continue block10;
                    }
                    case STRING: {
                        visitor.visitString(this, index, Protocol.toStringUtf8((byte[])value));
                        continue block10;
                    }
                    case FLOAT: {
                        visitor.visitFloat(this, index, ((Float)value).floatValue());
                        continue block10;
                    }
                    case DOUBLE: {
                        visitor.visitDouble(this, index, (Double)value);
                        continue block10;
                    }
                    case GROUP: {
                        visitor.visitGroup(this, index, (ProtocolMessage)value);
                        continue block10;
                    }
                    case FOREIGN: {
                        visitor.visitForeign(this, index, (ProtocolMessage)value);
                        continue block10;
                    }
                    default: {
                        throw new AssertionError((Object)"Cannot reach here");
                    }
                }
            }
        }

        public void visit(ProtocolMessage message, MessageVisitor visitor) {
            int size = this.size(message);
            if (!visitor.shouldVisitField(this, size)) {
                return;
            }
            block10: for (int index = 0; index < size; ++index) {
                Object value = this.presence == Presence.REPEATED ? this.getNthValue(message, index) : this.getSingleValue(message);
                switch (this.baseType) {
                    case BOOL: {
                        visitor.visitBoolean(this, index, (Boolean)value);
                        continue block10;
                    }
                    case INT32: 
                    case FIXED32: {
                        visitor.visitInteger(this, index, (Integer)value);
                        continue block10;
                    }
                    case INT64: 
                    case UINT64: 
                    case FIXED64: {
                        visitor.visitLong(this, index, (Long)value);
                        continue block10;
                    }
                    case STRING: {
                        if (value instanceof String) {
                            visitor.visitString(this, index, (String)value);
                            continue block10;
                        }
                        visitor.visitByteArray(this, index, (byte[])value);
                        continue block10;
                    }
                    case FLOAT: {
                        visitor.visitFloat(this, index, ((Float)value).floatValue());
                        continue block10;
                    }
                    case DOUBLE: {
                        visitor.visitDouble(this, index, (Double)value);
                        continue block10;
                    }
                    case GROUP: {
                        visitor.visitGroup(this, index, (ProtocolMessage)value);
                        continue block10;
                    }
                    case FOREIGN: {
                        visitor.visitForeign(this, index, (ProtocolMessage)value);
                        continue block10;
                    }
                    default: {
                        throw new AssertionError((Object)"Cannot reach here");
                    }
                }
            }
        }

        protected Object coerceReturnType(Object value) {
            if (value != null && (this.baseType == FieldBaseType.FOREIGN || this.baseType == FieldBaseType.GROUP) && this.foreignApiType == ApiType.PROTO2) {
                try {
                    return this.constructor.newInstance(value);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("Unexpected exception thrown when instantiate a downgraded message.", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("Couldn't use Java reflection to create downgraded ProtocolMessage for proto2 foreign type ", e);
                }
                catch (InvocationTargetException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new RuntimeException("Unexpected exception thrown when instantiate a downgraded message.", e);
                }
            }
            return value;
        }

        protected Object coerceSetterType(Object value) {
            if (value != null && this.foreignApiType == ApiType.PROTO2 && value instanceof MutableBridge.AbstractDowngradedMessage) {
                return ((MutableBridge.AbstractDowngradedMessage)value).unwrap();
            }
            return value;
        }

        public static <T extends MutableMessage> T downCastForeign(Object value) {
            if (value instanceof MutableBridge.AbstractDowngradedMessage) {
                return (T)((MutableBridge.AbstractDowngradedMessage)value).unwrap();
            }
            return (T)((MutableMessage)value);
        }

        @Nullable
        public Object getSingleValue(ProtocolMessage message) {
            try {
                return this.coerceReturnType(this.dataField.get(message));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        Object getSingleProto2Message(ProtocolMessage message) {
            try {
                return this.dataField.get(message);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        public Object getNthValue(ProtocolMessage message, int index) {
            try {
                Object value = this.dataField.get(message);
                if (this.baseType.isCompound()) {
                    return this.coerceReturnType(((List)value).get(index));
                }
                return this.coerceReturnType(Array.get(value, index));
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        Object getNthProto2Message(ProtocolMessage message, int index) {
            try {
                Object value = this.dataField.get(message);
                return ((List)value).get(index);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        private void checkRepeatedType(Object elem) {
            Preconditions.checkNotNull(elem);
            switch (this.baseType) {
                case INT32: 
                case FIXED32: {
                    int[] testIntArray = new int[1];
                    Array.set(testIntArray, 0, elem);
                    break;
                }
                case INT64: 
                case UINT64: 
                case FIXED64: {
                    long[] testLongArray = new long[1];
                    Array.set(testLongArray, 0, elem);
                    break;
                }
                case BOOL: {
                    boolean[] testBoolArray = new boolean[1];
                    Array.set(testBoolArray, 0, elem);
                    break;
                }
                case FLOAT: {
                    float[] testFloatArray = new float[1];
                    Array.set(testFloatArray, 0, elem);
                    break;
                }
                case DOUBLE: {
                    double[] testDoubleArray = new double[1];
                    Array.set(testDoubleArray, 0, elem);
                    break;
                }
                case STRING: {
                    byte[][] testStringArray = new byte[1][];
                    Array.set(testStringArray, 0, elem);
                    break;
                }
                case GROUP: 
                case FOREIGN: {
                    if (elem.getClass().equals(this.getSubclass())) break;
                    throw new IllegalArgumentException(this.getSubclass().getSimpleName() + " expected, " + elem.getClass().getSimpleName() + " found");
                }
            }
        }

        public void setNthValue(ProtocolMessage message, int index, Object elem) {
            if (this.presence != Presence.REPEATED) {
                throw new IllegalStateException("Can only add to repeated fields.");
            }
            elem = this.coerceSetterType(elem);
            this.checkRepeatedType(elem);
            try {
                Object value = this.dataField.get(message);
                if (this.baseType.isCompound()) {
                    if (value == null) {
                        throw new ArrayIndexOutOfBoundsException(index);
                    }
                    ((List)value).set(index, elem);
                } else {
                    if (index >= this.sizeField.getInt(message)) {
                        throw new ArrayIndexOutOfBoundsException(index);
                    }
                    Array.set(value, index, elem);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        void setNthProto2Message(ProtocolMessage message, int index, Object elem) {
            try {
                Object value = this.dataField.get(message);
                if (value == null) {
                    throw new ArrayIndexOutOfBoundsException(index);
                }
                ((List)value).set(index, elem);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        public void clear(ProtocolMessage message) {
            try {
                switch (this.presence) {
                    case REPEATED: {
                        if (this.sizeField != null) {
                            switch (this.baseType) {
                                case INT32: 
                                case FIXED32: {
                                    this.dataField.set(message, new int[0]);
                                    break;
                                }
                                case INT64: 
                                case UINT64: 
                                case FIXED64: {
                                    this.dataField.set(message, new long[0]);
                                    break;
                                }
                                case BOOL: {
                                    this.dataField.set(message, new boolean[0]);
                                    break;
                                }
                                case FLOAT: {
                                    this.dataField.set(message, new float[0]);
                                    break;
                                }
                                case DOUBLE: {
                                    this.dataField.set(message, new double[0]);
                                    break;
                                }
                                default: {
                                    this.dataField.set(message, new ProtocolMessage[0]);
                                }
                            }
                            this.sizeField.setInt(message, 0);
                            break;
                        }
                        List value = (List)this.dataField.get(message);
                        if (value != null) {
                            value.clear();
                        }
                        break;
                    }
                    case REQUIRED: 
                    case OPTIONAL: {
                        this.dataField.set(message, this.getSingleValue((ProtocolMessage)message.newInstance()));
                        if (this.bitTag == Integer.MIN_VALUE) {
                            this.sizeField.setBoolean(message, false);
                            break;
                        }
                        this.sizeField.setInt(message, this.sizeField.getInt(message) & ~(1 << this.bitTag));
                    }
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        public void setSingleValue(ProtocolMessage message, Object value) {
            if (value == null) {
                throw new NullPointerException("null is not a valid value for a ProtocolMessage field.");
            }
            value = this.coerceSetterType(value);
            if (this.presence == Presence.REPEATED) {
                throw new IllegalStateException("Field is repeated, not single value.");
            }
            try {
                this.dataField.set(message, value);
                if (this.bitTag == Integer.MIN_VALUE) {
                    this.sizeField.setBoolean(message, true);
                } else {
                    this.sizeField.setInt(message, this.sizeField.getInt(message) | 1 << this.bitTag);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        void setSingleProto2Message(ProtocolMessage message, Object value) {
            try {
                this.dataField.set(message, value);
                if (this.bitTag == Integer.MIN_VALUE) {
                    this.sizeField.setBoolean(message, true);
                } else {
                    this.sizeField.setInt(message, this.sizeField.getInt(message) | 1 << this.bitTag);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        public void addValue(ProtocolMessage message, Object elem) {
            if (this.presence != Presence.REPEATED) {
                throw new IllegalStateException("Can only add to repeated fields.");
            }
            elem = this.coerceSetterType(elem);
            try {
                Object value = this.dataField.get(message);
                if (this.baseType.isCompound()) {
                    if (value == null) {
                        value = new ArrayList(4);
                        this.dataField.set(message, value);
                    }
                    ((List)value).add(elem);
                } else {
                    int len;
                    int size = this.sizeField.getInt(message);
                    if (size == (len = Array.getLength(value))) {
                        switch (this.baseType) {
                            case INT32: 
                            case FIXED32: {
                                value = ProtocolSupport.growArray((int[])value);
                                break;
                            }
                            case INT64: 
                            case UINT64: 
                            case FIXED64: {
                                value = ProtocolSupport.growArray((long[])value);
                                break;
                            }
                            case BOOL: {
                                value = ProtocolSupport.growArray((boolean[])value);
                                break;
                            }
                            case FLOAT: {
                                value = ProtocolSupport.growArray((float[])value);
                                break;
                            }
                            case DOUBLE: {
                                value = ProtocolSupport.growArray((double[])value);
                            }
                        }
                        this.dataField.set(message, value);
                    }
                    Array.set(value, size, elem);
                    this.sizeField.setInt(message, size + 1);
                }
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        void addProto2Message(ProtocolMessage message, Object elem) {
            try {
                ArrayList value = this.dataField.get(message);
                if (value == null) {
                    value = new ArrayList(4);
                    this.dataField.set(message, value);
                }
                ((List)value).add(elem);
            }
            catch (IllegalAccessException e) {
                throw new AssertionError((Object)"ProtocolMessage must have field");
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("<FieldType: ");
            sb.append((Object)this.presence).append(' ');
            if (this.baseType == FieldBaseType.FOREIGN) {
                sb.append(this.subclass.getSimpleName());
            } else {
                sb.append((Object)this.baseType);
            }
            sb.append(' ').append(this.printName).append(" = ").append(this.tag).append(">");
            return sb.toString();
        }

        public byte[] getRawByteArray(ProtocolMessage protocolMessage, int index) {
            if (this.baseType != FieldBaseType.STRING) {
                throw new IllegalArgumentException("Must be String");
            }
            if (this.getPresence() == Presence.REPEATED) {
                return (byte[])this.getNthValue(protocolMessage, index);
            }
            return (byte[])this.getSingleValue(protocolMessage);
        }
    }

    public static enum ApiType {
        PROTO1,
        PROTO2;

    }

    public static enum WireType {
        NUMERIC(0),
        DOUBLE(1),
        STRING(2),
        STARTGROUP(3),
        ENDGROUP(4),
        FLOAT(5),
        ERROR(6);

        private final byte value;

        private WireType(int i) {
            this.value = (byte)i;
        }

        public byte getValue() {
            return this.value;
        }
    }

    public static enum Presence {
        OPTIONAL,
        REQUIRED,
        REPEATED;

    }

    public static enum FieldBaseType {
        INT32,
        FIXED32,
        INT64,
        UINT64,
        FIXED64,
        BOOL,
        FLOAT,
        DOUBLE,
        STRING,
        GROUP,
        FOREIGN;


        boolean isCompound() {
            return this == STRING || this == GROUP || this == FOREIGN;
        }

        boolean isScalar() {
            return !this.isCompound();
        }

        public boolean isFixed() {
            return this == FIXED32 || this == FIXED64 || this == BOOL;
        }

        public WireType getWireType() {
            switch (this) {
                case INT64: 
                case UINT64: 
                case INT32: 
                case BOOL: {
                    return WireType.NUMERIC;
                }
                case FIXED32: 
                case FLOAT: {
                    return WireType.FLOAT;
                }
                case FIXED64: 
                case DOUBLE: {
                    return WireType.DOUBLE;
                }
                case GROUP: {
                    return WireType.STARTGROUP;
                }
                case FOREIGN: {
                    return WireType.STRING;
                }
                case STRING: {
                    return WireType.STRING;
                }
            }
            return WireType.ERROR;
        }
    }

    public static interface Visitor {
        public boolean shouldVisitField(FieldType var1, int var2);

        public void visitBoolean(FieldType var1, int var2, boolean var3);

        public void visitInteger(FieldType var1, int var2, int var3);

        public void visitLong(FieldType var1, int var2, long var3);

        public void visitString(FieldType var1, int var2, String var3);

        public void visitFloat(FieldType var1, int var2, float var3);

        public void visitDouble(FieldType var1, int var2, double var3);

        public void visitGroup(FieldType var1, int var2, ProtocolMessage var3);

        public void visitForeign(FieldType var1, int var2, ProtocolMessage var3);

        public void visitRawMessage(ByteBuffer var1);
    }
}

