/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.acct;

import java.rmi.RemoteException;
import java.util.logging.Level;
import org.compiere.db.CConnection;
import org.compiere.interfaces.Server;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;

public final class Post {
    private static int s_serverTries = 0;
    private static Server s_server = null;
    private static CLogger log = CLogger.getCLogger(Post.class);

    public static boolean isServerActive() {
        boolean contactAgain = s_server == null && s_serverTries == 0;
        boolean ok = CConnection.get().isAppsServerOK(contactAgain);
        if (ok) {
            s_serverTries = 0;
            return true;
        }
        if (s_serverTries > 1) {
            return false;
        }
        CLogMgt.enable((boolean)false);
        try {
            log.config("try #" + ++s_serverTries);
            ok = CConnection.get().isAppsServerOK(true);
            if (ok) {
                s_serverTries = 0;
            }
        }
        catch (Exception ex) {
            ok = false;
            s_server = null;
        }
        CLogMgt.enable((boolean)true);
        return ok;
    }

    public static String getServerVersion() {
        return CConnection.get().getServerVersion();
    }

    public static String postImmediate(Ctx ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        log.config("AD_Table_ID=" + AD_Table_ID + "/" + Record_ID + ", Force=" + force);
        String error = null;
        if (Post.isServerActive()) {
            log.config("trying server");
            try {
                s_server = CConnection.get().getServer();
                if (s_server == null) {
                    return "NoAppsServer";
                }
                error = s_server.postImmediate(ctx, AD_Client_ID, AD_Table_ID, Record_ID, force, null);
                log.config("from Server: " + error == null ? "OK" : error);
            }
            catch (RemoteException e) {
                log.log(Level.WARNING, "(RE)", (Throwable)e);
                error = e.getMessage();
                s_server = null;
            }
            catch (Exception e) {
                log.log(Level.WARNING, "ex", (Throwable)e);
                error = e.getMessage();
                s_server = null;
            }
        } else {
            return "NoAppsServer";
        }
        return error;
    }
}

