/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.search;

import com.ampiere.search.ComponentBean;
import com.ampiere.search.IDColumn;
import com.ampiere.search.Info;
import com.ampiere.search.Info_Column;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.logging.Level;
import org.compiere.framework.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoCashLine
extends Info {
    private Info_Column[] s_cashLayout = null;

    protected InfoCashLine(int WindowNo, String value, boolean multiSelection, String whereClause, Ctx ctx) {
        super(WindowNo, "cl", "C_CashLine_ID", multiSelection, whereClause, ctx);
        this.log.info("InfoCashLine");
        this.title = Msg.translate((Ctx)ctx, (String)"InfoCashLine");
        int i = 0;
        this.s_cashLayout = new Info_Column[12];
        this.columnAttrList = new ArrayList();
        this.s_cashLayout[i++] = new Info_Column(" ", "cl.C_CashLine_ID", IDColumn.class);
        this.columnAttrList.add(1);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"C_CashBook_ID"), "(SELECT cb.Name FROM C_CashBook cb WHERE cb.C_CashBook_ID=c.C_CashBook_ID)", String.class);
        this.columnAttrList.add(1);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"Name"), "c.Name", String.class);
        this.columnAttrList.add(1);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"StatementDate"), "c.StatementDate", Timestamp.class);
        this.columnAttrList.add(1);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"Line"), "cl.Line", Integer.class);
        this.columnAttrList.add(1);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"Amount"), "cl.Amount", BigDecimal.class, true, true, null);
        this.columnAttrList.add(1);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"C_Invoice_ID"), "(SELECT i.DocumentNo||'_'||" + DB.TO_CHAR((String)"i.DateInvoiced", (int)15, (String)Env.getAD_Language((Ctx)ctx)) + "||'_'||" + DB.TO_CHAR((String)"i.GrandTotal", (int)12, (String)Env.getAD_Language((Ctx)ctx)) + " FROM C_Invoice i WHERE i.C_Invoice_ID=cl.C_Invoice_ID)", String.class);
        this.columnAttrList.add(0);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"C_BankAccount_ID"), "(SELECT b.Name||' '||ba.AccountNo FROM C_Bank b, C_BankAccount ba WHERE b.C_Bank_ID=ba.C_Bank_ID AND ba.C_BankAccount_ID=cl.C_BankAccount_ID)", String.class);
        this.columnAttrList.add(0);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"C_Charge_ID"), "(SELECT ca.Name FROM C_Charge ca WHERE ca.C_Charge_ID=cl.C_Charge_ID)", String.class);
        this.columnAttrList.add(0);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"DiscountAmt"), "cl.DiscountAmt", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"WriteOffAmt"), "cl.WriteOffAmt", BigDecimal.class);
        this.columnAttrList.add(0);
        this.s_cashLayout[i++] = new Info_Column(Msg.translate((Ctx)ctx, (String)"Description"), "cl.Description", String.class);
        this.columnAttrList.add(0);
        try {
            String s = "";
            if (value != null && value.length() > 0) {
                s = value;
            }
            this.statInit(ctx, s);
            this.p_loadedOK = this.initInfo();
        }
        catch (Exception e) {
            return;
        }
    }

    private void statInit(Ctx ctx, String value) throws Exception {
        MLookup lookupCashBook = MLookupFactory.get((Ctx)ctx, (int)this.p_WindowNo, (int)5249, (int)19);
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"C_CashBook_ID"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("C_CashBook_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 4, this.getTableDirectList((Lookup)lookupCashBook), "left", "middle", "", 218));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"Name"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("Name", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 3, value, "left", "middle", "", 220));
        this.componentMapping.put("AbsoluteAmt", new Integer(this.componentList.size()));
        ComponentBean bean = new ComponentBean(Msg.translate((Ctx)ctx, (String)"AbsoluteAmt"), 6, "N", "left", "middle", "", 0);
        bean.setColSpan(2);
        this.componentList.add(bean);
        this.componentList.add(new ComponentBean(0));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"C_Invoice_ID"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("C_Invoice_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("C_Invoice_ID", 7, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"StatementDate"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("DateFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"DateFrom"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean("-", 1, "", "center", "middle", "", 0));
        this.componentMapping.put("DateTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"DateTo"), 5, "", "left", "middle", "", 198));
        this.componentList.add(new ComponentBean(0));
        MLookup lookupBankAccount = MLookupFactory.get((Ctx)ctx, (int)this.p_WindowNo, (int)5295, (int)19);
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"C_BankAccount_ID"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("C_BankAccount_ID", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean("", 4, this.getTableDirectList((Lookup)lookupBankAccount), "left", "middle", "", 218));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"Amount"), 1, "", "right", "middle", "", 0));
        this.componentMapping.put("AmtFrom", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"AmtFrom"), 3, "", "left", "middle", "", 220));
        this.componentList.add(new ComponentBean("-", 1, "", "center", "middle", "", 0));
        this.componentMapping.put("AmtTo", new Integer(this.componentList.size()));
        this.componentList.add(new ComponentBean(Msg.translate((Ctx)ctx, (String)"AmtTo"), 3, "", "left", "middle", "", 220));
    }

    private boolean initInfo() {
        StringBuffer where = new StringBuffer("cl.IsActive='Y'");
        if (this.p_whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace((String)this.p_whereClause, (String)"C_CashLine.", (String)"cl."));
        }
        this.prepareTable(this.s_cashLayout, "C_CashLine cl INNER JOIN C_Cash c ON (cl.C_Cash_ID=c.C_Cash_ID)", where.toString(), "2,3,cl.Line");
        return true;
    }

    protected String createQuery(Hashtable valueMapping, SimpleDateFormat dateFormat) {
        StringBuffer sql = new StringBuffer();
        String s = this.getComponetValue(valueMapping, "Name");
        if (s != null) {
            if (!(s = s.toUpperCase()).endsWith("%")) {
                s = s + "%";
            }
            sql.append(" AND UPPER(c.Name) LIKE ?");
            sql.append(DB.TO_STRING((String)s));
        }
        if ((s = this.getComponetValue(valueMapping, "C_CashBook_ID")) != null) {
            sql.append(" AND c.C_CashBook_ID=");
            sql.append(Integer.parseInt(s));
        }
        if ((s = this.getComponetValue(valueMapping, "C_Invoice_ID")) != null) {
            sql.append(" AND cl.C_Invoice_ID=");
            sql.append(Integer.parseInt(s));
        }
        String from = this.getComponetValue(valueMapping, "DateFrom");
        String to = this.getComponetValue(valueMapping, "DateTo");
        if (from != null || to != null) {
            Timestamp fromT = null;
            Timestamp toT = null;
            try {
                Date d;
                if (from != null) {
                    d = dateFormat.parse(from);
                    fromT = new Timestamp(d.getTime());
                }
                if (to != null) {
                    d = dateFormat.parse(to);
                    toT = new Timestamp(d.getTime());
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoCashLine : createQuery : Date convert error ", (Throwable)e);
            }
            if (fromT == null && toT != null) {
                sql.append(" AND TRUNC(c.StatementDate) <= ");
                sql.append(DB.TO_DATE((Timestamp)toT, (boolean)true));
            } else if (fromT != null && toT == null) {
                sql.append(" AND TRUNC(c.StatementDate) >= ");
                sql.append(DB.TO_DATE((Timestamp)fromT, (boolean)true));
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(c.StatementDate) BETWEEN ");
                sql.append(DB.TO_DATE((Timestamp)fromT, (boolean)true));
                sql.append(" AND ");
                sql.append(DB.TO_DATE((Timestamp)toT, (boolean)true));
            }
        }
        from = this.getComponetValue(valueMapping, "AmtFrom");
        to = this.getComponetValue(valueMapping, "AmtTo");
        if (from != null || to != null) {
            BigDecimal fromB = null;
            BigDecimal toB = null;
            try {
                fromB = new BigDecimal(from);
                toB = new BigDecimal(to);
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "InfoPayment : createQuery : To BigDecimal ", (Throwable)e);
            }
            s = this.getComponetValue(valueMapping, "AbsoluteAmt");
            if (s != null && "Y".equalsIgnoreCase(s)) {
                sql.append(" AND ABS(cl.Amount)");
            } else {
                sql.append(" AND cl.Amount");
            }
            if (fromB == null && toB != null) {
                sql.append(" <= ");
                sql.append(toB);
            } else if (from != null && to == null) {
                sql.append(" >= ");
                sql.append(fromB);
            } else if (from != null && to != null) {
                sql.append(" BETWEEN ");
                sql.append(fromB);
                sql.append(" AND ");
                sql.append(toB);
            }
        }
        this.log.fine(sql.toString());
        return sql.toString();
    }

    void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
    }

    protected String getSQLWhere() {
        if (this.p_sqlWhere != null && this.p_sqlWhere.length() > 0) {
            return this.p_sqlWhere;
        }
        return "";
    }
}

