/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.util;

import com.ampiere.web.struts.common.PopupBaseForm;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.logging.Level;
import org.apache.commons.lang.StringUtils;
import org.apache.ecs.Element;
import org.apache.ecs.xhtml.head;
import org.apache.ecs.xhtml.input;
import org.apache.ecs.xhtml.link;
import org.apache.ecs.xhtml.script;
import org.apache.ecs.xhtml.span;
import org.apache.ecs.xhtml.td;
import org.compiere.framework.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MRole;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.compiere.util.WebEnv;
import org.compiere.util.WebSessionCtx;

public class AmpiereUtil {
    private static CLogger log = CLogger.getCLogger(AmpiereUtil.class);
    public static final int MAX_RECORD_NUM = 1000;

    public static String maskHTML(String content) {
        String s = Util.maskHTML((String)content);
        if (WebEnv.NBSP.equalsIgnoreCase(s) || "&nbsp".equalsIgnoreCase(s)) {
            return "";
        }
        return s;
    }

    public static String maskHtmlCR(String content) {
        String s = AmpiereUtil.maskHTML(content);
        s = s.replaceAll("\n", WebEnv.NBSP);
        return s;
    }

    public static int getFixedColumnID(String columnName) {
        if (columnName == null) {
            return 0;
        }
        int AD_Column_ID = 0;
        if (columnName.indexOf("BPartner") >= 0) {
            AD_Column_ID = 3499;
        } else if (columnName.indexOf("Product") >= 0) {
            AD_Column_ID = 3840;
        } else if (columnName.indexOf("Invoice") >= 0) {
            AD_Column_ID = 5355;
        } else if (columnName.indexOf("Asset") >= 0) {
            AD_Column_ID = 271;
        } else if (columnName.indexOf("Order") >= 0) {
            AD_Column_ID = 12925;
        } else if (columnName.indexOf("InOut") < 0) {
            if (columnName.indexOf("Payment") >= 0) {
                AD_Column_ID = 4884;
            } else if (columnName.indexOf("CashLine") < 0) {
                if (columnName.indexOf("ResourceAssigment") >= 0) {
                    AD_Column_ID = 6851;
                } else if (columnName.indexOf("Currency") >= 0) {
                    AD_Column_ID = 3505;
                } else if (columnName.indexOf("User") >= 0) {
                    AD_Column_ID = 10510;
                }
            }
        }
        return AD_Column_ID;
    }

    public static String getFixedColumnName(String columnName) {
        String id = "General";
        if (columnName == null) {
            return id;
        }
        if (columnName.indexOf("BPartner") >= 0) {
            id = "BPartner";
        } else if (columnName.indexOf("Product") >= 0) {
            id = "Product";
        } else if (columnName.indexOf("Invoice") >= 0) {
            id = "Invoice";
        } else if (columnName.indexOf("Asset") >= 0) {
            id = "Asset";
        } else if (columnName.indexOf("Order") >= 0) {
            id = "Order";
        } else if (columnName.indexOf("InOut") >= 0) {
            id = "InOut";
        } else if (columnName.indexOf("Payment") >= 0) {
            id = "Payment";
        } else if (columnName.indexOf("CashLine") >= 0) {
            id = "CashLine";
        } else if (columnName.indexOf("ResourceAssignment") >= 0) {
            id = "Assignment";
        }
        return id;
    }

    public static String getMonths(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        return AmpiereUtil.generateJavascriptArray(formatDate.getDateFormatSymbols().getMonths());
    }

    public static String getShortMonths(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        return AmpiereUtil.generateJavascriptArray(formatDate.getDateFormatSymbols().getShortMonths());
    }

    public static String getWeeks(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        String[] wk = formatDate.getDateFormatSymbols().getWeekdays();
        String[] weekss = new String[7];
        for (int i = 1; i < wk.length; ++i) {
            weekss[i - 1] = wk[i];
        }
        return AmpiereUtil.generateJavascriptArray(weekss);
    }

    public static String getShortWeeks(Locale loc) {
        SimpleDateFormat formatDate = (SimpleDateFormat)DateFormat.getDateInstance(1, loc);
        String[] swk = formatDate.getDateFormatSymbols().getShortWeekdays();
        String[] shortWeekss = new String[7];
        for (int i = 1; i < swk.length; ++i) {
            shortWeekss[i - 1] = swk[i];
        }
        return AmpiereUtil.generateJavascriptArray(shortWeekss);
    }

    public static String generateJavascriptArray(String[] p2) {
        String s = "new Array(";
        for (int i = 0; i < p2.length; ++i) {
            if (p2[i] == null || p2[i].length() <= 0) continue;
            s = s + "\"" + p2[i] + "\",";
        }
        s = s.substring(0, s.length() - 1);
        s = s + ")";
        return s;
    }

    public static head addDatePicker(head hd, WebSessionCtx wsc) {
        AmpiereUtil.addDateTimePicker(hd, wsc);
        return hd;
    }

    public static head addDateTimePicker(head hd, WebSessionCtx wsc) {
        hd.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory((String)"js/protocalendar-js-1.1.0/javascripts/prototype.js")));
        hd.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory((String)"js/protocalendar-js-1.1.0/javascripts/effects.js")));
        hd.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory((String)"js/protocalendar-js-1.1.0/javascripts/protocalendar.js")));
        hd.addElement((Element)new script((Element)null, WebEnv.getBaseDirectory((String)"js/protocalendar-js-1.1.0/javascripts/lang_ja.js")));
        hd.addElement((Element)new link(WebEnv.getBaseDirectory((String)"js/protocalendar-js-1.1.0/stylesheets/simple.css"), "stylesheet", "text/css"));
        return hd;
    }

    public static void addDateTimePickerScript(Element element, String inputBoxId, String buttonId) {
        StringBuffer sb = new StringBuffer();
        sb.append("InputCalendar.createOnLoaded('").append(inputBoxId + "',").append("{format: 'yyyy/mm/dd HH:MM:ss JST',").append("enableHourMinute: true,").append("lang: 'ja',").append("triggers: ['" + buttonId + "'],").append("inputReadOnly: true});");
        element.addElementToRegistry((Element)new script(sb.toString()));
    }

    public static void addDatePickerScript(Element element, String inputBoxId, String buttonId) {
        StringBuffer sb = new StringBuffer();
        sb.append("InputCalendar.createOnLoaded('").append(inputBoxId + "',").append("{format: 'yyyy/mm/dd',").append("enableHourMinute: false,").append("lang: 'ja',").append("triggers: ['" + buttonId + "'],").append("inputReadOnly: true});");
        element.addElementToRegistry((Element)new script(sb.toString()));
    }

    public static td createButtons(Ctx ctx, boolean hasSubmit) {
        td tdButton = (td)new td().setClass("button-box");
        if (hasSubmit) {
            tdButton.addElement((Element)AmpiereUtil.createImageButton(ctx, "Ok", "this.form.submit();"));
            tdButton.addElement((Element)new span("OK"));
        }
        tdButton.addElement((Element)AmpiereUtil.createImageButton(ctx, "Cancel", "window.opener.top.WWindow.document.WForm.PCommand.value='Refresh';window.opener.top.WWindow.document.WForm.submit();window.close();"));
        tdButton.addElement((Element)new span("\u30ad\u30e3\u30f3\u30bb\u30eb"));
        return tdButton;
    }

    public static input createImageButton(Ctx ctx, String name, String script2) {
        input imgButton = new input("image", name, name);
        imgButton.setID("Popup" + name);
        imgButton.setOnClick(script2);
        imgButton.setSrc(WebEnv.getImageDirectory((String)(name + "32.png")));
        imgButton.setAlt(Msg.translate((Ctx)ctx, (String)name));
        return imgButton;
    }

    public static int setLargeRecordMsg(Ctx ctx, PopupBaseForm form, int rowNum) {
        if (rowNum > 1000) {
            MessageFormat mf = null;
            try {
                mf = new MessageFormat(Msg.getMsg((String)Env.getAD_Language((Ctx)ctx), (String)"LargeRecords"));
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "LargeRecords=" + Msg.getMsg((String)Env.getAD_Language((Ctx)ctx), (String)"LargeRecords"), (Throwable)e);
            }
            Object[] arguments = new Object[]{new Integer(rowNum), new Integer(1000)};
            form.setLargeRecords(mf.format(arguments));
            return 1000;
        }
        form.setLargeRecords("");
        return rowNum;
    }

    public static String getDirectAccessSQL(Ctx ctx, Lookup lookup, String columnName, String text) {
        int AD_Reference_ID;
        StringBuffer sql = new StringBuffer();
        String tableName = columnName.substring(0, columnName.length() - 3);
        String keyColumnName = columnName;
        if (columnName.equals("M_Product_ID")) {
            ctx.setContext(1113, "M_Product_ID", "0");
            ctx.setContext(1113, "M_AttributeSetInstance_ID", "0");
            sql.append("SELECT M_Product_ID FROM M_Product WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPC LIKE ").append(DB.TO_STRING((String)text)).append(")");
        } else if (columnName.equals("C_BPartner_ID")) {
            sql.append("SELECT C_BPartner_ID FROM C_BPartner WHERE (UPPER(Value) LIKE ").append(DB.TO_STRING((String)text)).append(" OR UPPER(Name) LIKE ").append(DB.TO_STRING((String)text)).append(")");
        } else if (columnName.equals("C_Order_ID")) {
            sql.append("SELECT C_Order_ID FROM C_Order WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
        } else if (columnName.equals("C_Invoice_ID")) {
            sql.append("SELECT C_Invoice_ID FROM C_Invoice WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
        } else if (columnName.equals("M_InOut_ID")) {
            sql.append("SELECT M_InOut_ID FROM M_InOut WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
        } else if (columnName.equals("C_Payment_ID")) {
            sql.append("SELECT C_Payment_ID FROM C_Payment WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
        } else if (columnName.equals("GL_JournalBatch_ID")) {
            sql.append("SELECT GL_JournalBatch_ID FROM GL_JournalBatch WHERE UPPER(DocumentNo) LIKE ").append(DB.TO_STRING((String)text));
        } else if (columnName.equals("SalesRep_ID")) {
            sql.append("SELECT AD_User_ID FROM AD_User WHERE UPPER(Name) LIKE ").append(DB.TO_STRING((String)text));
            tableName = "AD_User";
            keyColumnName = "AD_User_ID";
        }
        if (sql.length() > 0) {
            String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
            if (wc != null && wc.length() > 0) {
                sql.append(" AND ").append(wc);
            }
            sql.append(" AND IsActive='Y'");
            log.finest(columnName + " (predefined) " + sql.toString());
            return MRole.getDefault().addAccessSQL(sql.toString(), tableName, false, false);
        }
        if (lookup != null && lookup instanceof MLookup && (AD_Reference_ID = ((MLookup)lookup).getAD_Reference_Value_ID()) != 0) {
            String query = "SELECT kc.ColumnName, dc.ColumnName, t.TableName FROM AD_Ref_Table rt INNER JOIN AD_Column kc ON (rt.AD_Key=kc.AD_Column_ID) INNER JOIN AD_Column dc ON (rt.AD_Display=dc.AD_Column_ID) INNER JOIN AD_Table t ON (rt.AD_Table_ID=t.AD_Table_ID) WHERE rt.AD_Reference_ID=?";
            String displayColumnName = null;
            CPreparedStatement pstmt = null;
            try {
                pstmt = DB.prepareStatement((String)query, null);
                pstmt.setInt(1, AD_Reference_ID);
                ResultSet rs = pstmt.executeQuery();
                if (rs.next()) {
                    keyColumnName = rs.getString(1);
                    displayColumnName = rs.getString(2);
                    tableName = rs.getString(3);
                }
                rs.close();
                pstmt.close();
                pstmt = null;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, query, (Throwable)e);
            }
            try {
                if (pstmt != null) {
                    pstmt.close();
                }
                pstmt = null;
            }
            catch (Exception e) {
                pstmt = null;
            }
            if (displayColumnName != null) {
                sql = new StringBuffer();
                sql.append("SELECT ").append(keyColumnName).append(" FROM ").append(tableName).append(" WHERE UPPER(").append(displayColumnName).append(") LIKE ").append(DB.TO_STRING((String)text)).append(" AND IsActive='Y'");
                String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
                if (wc != null && wc.length() > 0) {
                    sql.append(" AND ").append(wc);
                }
                log.finest(columnName + " (Table) " + sql.toString());
                return MRole.getDefault().addAccessSQL(sql.toString(), tableName, false, false);
            }
        }
        String query = "SELECT t.TableName, c.ColumnName FROM AD_Column c  INNER JOIN AD_Table t ON (c.AD_Table_ID=t.AD_Table_ID AND t.IsView='N') WHERE (c.ColumnName IN ('DocumentNo', 'Value', 'Name') OR c.IsIdentifier='Y') AND c.AD_Reference_ID IN (10,14) AND EXISTS (SELECT * FROM AD_Column cc WHERE cc.AD_Table_ID=t.AD_Table_ID AND cc.IsKey='Y' AND cc.ColumnName=?)";
        keyColumnName = columnName;
        sql = new StringBuffer();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)query, null);
            pstmt.setString(1, keyColumnName);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                if (sql.length() != 0) {
                    sql.append(" OR ");
                }
                tableName = rs.getString(1);
                sql.append("UPPER(").append(rs.getString(2)).append(") LIKE ").append(DB.TO_STRING((String)text));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException ex) {
            log.log(Level.SEVERE, query, (Throwable)ex);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
        }
        catch (SQLException ex1) {
            // empty catch block
        }
        pstmt = null;
        if (sql.length() == 0) {
            log.log(Level.SEVERE, columnName + " (TableDir) - no standard/identifier columns");
            return "";
        }
        StringBuffer retValue = new StringBuffer("SELECT ").append(columnName).append(" FROM ").append(tableName).append(" WHERE ").append(sql).append(" AND IsActive='Y'");
        String wc = AmpiereUtil.getWhereClause(ctx, lookup, columnName);
        if (wc != null && wc.length() > 0) {
            retValue.append(" AND ").append(wc);
        }
        log.finest(columnName + " (TableDir) " + sql.toString());
        return MRole.getDefault().addAccessSQL(retValue.toString(), tableName, false, false);
    }

    public static String getWhereClause(Ctx ctx, Lookup lookup, String columnName) {
        String validation;
        String whereClause = "";
        if (lookup == null) {
            return "";
        }
        if (lookup.getZoomQuery() != null) {
            whereClause = lookup.getZoomQuery().getWhereClause();
        }
        if ((validation = lookup.getValidation()) == null) {
            validation = "";
        }
        if (whereClause.length() == 0) {
            whereClause = validation;
        } else if (validation.length() > 0) {
            whereClause = whereClause + " AND " + validation;
        }
        if (whereClause.indexOf(64) != -1) {
            String validated = Env.parseContext((Ctx)ctx, (int)lookup.getWindowNo(), (String)whereClause, (boolean)false);
            if (validated.length() == 0) {
                log.severe(columnName + " - Cannot Parse=" + whereClause);
            } else {
                log.fine(columnName + " - Parsed: " + validated);
                return validated;
            }
        }
        return whereClause;
    }

    public static int getOnly_Warehouse_ID(Ctx ctx, int windowNo) {
        String only_Warehouse = ctx.getContext(windowNo, "M_Warehouse_ID", true);
        int only_Warehouse_ID = 0;
        try {
            if (only_Warehouse != null && only_Warehouse.length() > 0) {
                only_Warehouse_ID = Integer.parseInt(only_Warehouse);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        return only_Warehouse_ID;
    }

    public static String sanitizing(String str) {
        if (!StringUtils.isEmpty(str)) {
            if (str.indexOf("&amp;") >= 0 || str.indexOf("&lt;") >= 0 || str.indexOf("&gt;") >= 0 || str.indexOf("&quot;") >= 0 || str.indexOf("&#39;") >= 0) {
                return str;
            }
            str = str.replaceAll("&", "&amp;");
            str = str.replaceAll("<", "&lt;");
            str = str.replaceAll(">", "&gt;");
            str = str.replaceAll("\"", "&quot;");
            str = str.replaceAll("'", "&#39;");
        }
        return str;
    }
}

