/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.GenerateShipmentFromOrderForm;
import java.util.Iterator;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MPInstance;
import org.compiere.model.MPInstancePara;
import org.compiere.model.MProcess;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.WebSessionCtx;

public class GenerateShipmentFromOrderAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String ORDER_LIST = "orderlist";
    private static final String SHIPMENT_LIST = "shipmentlist";
    private static final String ACTION_FORM = "GenerateShipmentFromOrderForm";
    private static final String ERROR_FORWARD = "error";
    private static final int ORDER_BUSINESS_PARTNER_COLUMN_ID = 2762;
    private static final int FORM_ID = 110;

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get((HttpServletRequest)request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ActionForward actionForward = mapping.findForward(SHIPMENT_LIST);
        GenerateShipmentFromOrderForm myForm = (GenerateShipmentFromOrderForm)request.getAttribute(ACTION_FORM);
        String column = myForm.getChangedColumn();
        if (column.equals("wareHouseId")) {
            actionForward = mapping.findForward(ORDER_LIST);
        } else if (column.equals("businessPartnerId")) {
            actionForward = mapping.findForward(ORDER_LIST);
        } else if (column.equals("businessPartnerName")) {
            MLookup lookup = null;
            try {
                lookup = MLookupFactory.get((Ctx)wsc.ctx, (int)0, (int)2762, (int)19, (Language)wsc.language, (String)"C_BPartner_ID", (int)0, (boolean)false, (String)("UPPER(NAME) LIKE '" + myForm.getBusinessPartnerName().toUpperCase() + "%' "));
                Iterator keyNames = lookup.getData(true, false, true, false).iterator();
                if (keyNames.hasNext()) {
                    KeyNamePair keyName = (KeyNamePair)keyNames.next();
                    myForm.setBusinessPartnerId(keyName.getKey());
                    myForm.setBusinessPartnerName(keyName.getName());
                } else {
                    myForm.setBusinessPartnerId(999999999);
                }
            }
            catch (Exception e) {
                this.log.log(Level.SEVERE, "MLookupFactory.get AD_Column_ID=2762", (Throwable)e);
            }
            actionForward = mapping.findForward(ORDER_LIST);
        } else if (myForm.getOrderIdList() != null && myForm.getOrderIdList().length > 0) {
            myForm.setMainWindowTitle(wsc.ctx.getContext("FormName") + " - " + wsc.loginInfo);
            myForm.setPageTitle(wsc.ctx.getContext("FormName"));
            this.generateShipments(wsc.ctx, myForm);
            actionForward = mapping.findForward(SHIPMENT_LIST);
        } else {
            actionForward = mapping.findForward(ORDER_LIST);
        }
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return actionForward;
    }

    private void generateShipments(Ctx ctx, GenerateShipmentFromOrderForm form2) {
        String whereClause = this.getWhereClause(form2.getOrderIdList());
        String sql = "UPDATE C_Order SET IsSelected = 'N' WHERE IsSelected='Y' AND AD_Client_ID=" + ctx.getAD_Client_ID();
        int no = DB.executeUpdate((String)sql, null);
        sql = "UPDATE C_Order SET IsSelected='Y' WHERE " + whereClause;
        no = DB.executeUpdate((String)sql, null);
        if (no == 0) {
            form2.setResultInfo("No Shipments");
            return;
        }
        int processId = 199;
        MProcess process = MProcess.get((Ctx)ctx, (int)processId);
        MPInstance instance = new MPInstance(ctx, processId, 0);
        if (!instance.save()) {
            form2.setResultInfo(Msg.getMsg((Ctx)Env.getCtx(), (String)"ProcessNoInstance"));
            return;
        }
        ProcessInfo pi = new ProcessInfo("VInOutGen", processId);
        pi.setAD_PInstance_ID(instance.getAD_PInstance_ID());
        pi.setAD_User_ID(ctx.getAD_User_ID());
        pi.setAD_Client_ID(ctx.getAD_Client_ID());
        MPInstancePara ip = new MPInstancePara(instance, 10);
        ip.setParameter("Selection", "Y");
        if (!ip.save()) {
            form2.setResultInfo("No Parameter added");
            return;
        }
        ip = new MPInstancePara(instance, 20);
        ip.setParameter("M_Warehouse_ID", form2.getWareHouseId());
        if (!ip.save()) {
            form2.setResultInfo("No Parameter added");
            return;
        }
        boolean processOK = false;
        if (process.isJavaProcess()) {
            Trx trx = Trx.get((String)Trx.createTrxName((String)"WebPrc"), (boolean)true);
            try {
                processOK = process.processIt(pi, trx);
                trx.commit();
                trx.close();
            }
            catch (Throwable t) {
                trx.rollback();
                trx.close();
            }
            if (!processOK || pi.isError()) {
                processOK = false;
            }
            if (processOK) {
                ProcessInfoUtil.setLogFromDB((ProcessInfo)pi);
                StringBuffer iText = new StringBuffer();
                iText.append("<b>").append(pi.getSummary()).append("</b><br>(").append(Msg.getMsg((Ctx)ctx, (String)"InOutGenerateInfo")).append(")<br>").append(pi.getLogInfo(true)).append("<br><br>");
                form2.setResultInfo(iText.toString());
                sql = "UPDATE C_Order SET IsSelected='N' WHERE " + whereClause;
                no = DB.executeUpdate((String)sql, null);
                this.log.config("Reset=" + no);
            } else {
                this.log.log(Level.SEVERE, "Error:" + pi.getSummary());
            }
        }
    }

    private String getWhereClause(int[] orderIds) {
        StringBuffer sb = new StringBuffer("");
        if (orderIds.length > 0) {
            sb.append("C_Order_ID");
            if (orderIds.length > 1) {
                sb.append(" IN (");
            } else {
                sb.append("=");
            }
            for (int i2 = 0; i2 < orderIds.length; ++i2) {
                if (i2 > 0) {
                    sb.append(",");
                }
                sb.append(String.valueOf(orderIds[i2]));
            }
            if (orderIds.length > 1) {
                sb.append(")");
            }
        }
        return sb.toString();
    }
}

