/*
 * Decompiled with CFR 0.152.
 */
package com.ampiere.web.struts.form;

import com.ampiere.web.struts.form.PaymentSelectionForm;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParsePosition;
import java.util.Date;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.util.CLogger;
import org.compiere.util.Ctx;
import org.compiere.util.Msg;
import org.compiere.util.WebSessionCtx;

public class PaymentSelectionAction
extends Action {
    private CLogger log = CLogger.getCLogger(((Object)((Object)this)).getClass());
    private static final String PAYMENT_LIST = "paymentlist";
    private static final String ACTION_FORM = "PaymentSelectionForm";
    private static final String ERROR_FORWARD = "error";

    public final ActionForward execute(ActionMapping mapping, ActionForm form2, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebSessionCtx wscTest = WebSessionCtx.get((HttpServletRequest)request);
        if (wscTest == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            request.setAttribute("sessionTimeoutInfo", (Object)"Session Time Out. Please login again.");
            return mapping.findForward("sessionTimeout");
        }
        this.log.fine("Begin " + ((Object)((Object)this)).getClass().getName() + ";execute");
        WebSessionCtx wsc = WebSessionCtx.get((HttpServletRequest)request);
        if (wsc == null) {
            this.log.log(Level.SEVERE, "Session Time Out.");
            return mapping.findForward(ERROR_FORWARD);
        }
        ActionForward actionForward = mapping.findForward(PAYMENT_LIST);
        PaymentSelectionForm myForm = (PaymentSelectionForm)request.getAttribute(ACTION_FORM);
        String column = myForm.getChangedColumn();
        if (column.equals("bankAccount")) {
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else if (column.equals("businessPartner")) {
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else if (column.equals("onlyDueInvoices")) {
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else if (column.equals("paymentDate")) {
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else if (myForm.getInvoiceIdList() != null && myForm.getInvoiceIdList().length > 0) {
            myForm.setMainWindowTitle(wsc.ctx.getContext("FormName") + " - " + wsc.loginInfo);
            myForm.setPageTitle(wsc.ctx.getContext("FormName"));
            this.generatePaySelect(wsc, myForm);
            actionForward = mapping.findForward(PAYMENT_LIST);
        } else {
            actionForward = mapping.findForward(PAYMENT_LIST);
        }
        myForm.setChangedColumn(null);
        request.setAttribute(ACTION_FORM, (Object)myForm);
        this.log.fine("End " + ((Object)((Object)this)).getClass().getName() + ";execute");
        return actionForward;
    }

    private void generatePaySelect(WebSessionCtx wsc, PaymentSelectionForm form2) {
        String trxName = null;
        String[] invoiceInfo = form2.getInvoiceIdList();
        if (invoiceInfo == null || invoiceInfo.length == 0) {
            return;
        }
        MPaySelection paySelection = new MPaySelection(wsc.ctx, 0, trxName);
        paySelection.setName(Msg.getMsg((Ctx)wsc.ctx, (String)"VPaySelect") + " - " + form2.getPaymentDate());
        Date payDate = wsc.dateFormat.parse(form2.getPaymentDate(), new ParsePosition(0));
        paySelection.setPayDate(new Timestamp(payDate.getTime()));
        String[] bankInfo = form2.getBankAccount().split("\\|");
        paySelection.setC_BankAccount_ID(Integer.valueOf(bankInfo[0]).intValue());
        paySelection.setIsApproved(true);
        if (!paySelection.save()) {
            form2.setResultInfo("alert('" + Msg.translate((Ctx)wsc.ctx, (String)"SaveError") + " : " + Msg.translate((Ctx)wsc.ctx, (String)"C_PaySelection_ID") + "');");
            return;
        }
        this.log.config(paySelection.toString());
        int rows = invoiceInfo.length;
        int line = 0;
        for (int i2 = 0; i2 < rows; ++i2) {
            MPaySelectionLine psl = new MPaySelectionLine(paySelection, line += 10, form2.getPaymentRule());
            String[] invoice = invoiceInfo[i2].split("\\|");
            int invoiceId = Integer.valueOf(invoice[0]);
            BigDecimal openAmount = new BigDecimal(invoice[1]);
            BigDecimal payAmount = new BigDecimal(invoice[2]);
            boolean isSOTrx = false;
            psl.setInvoice(invoiceId, isSOTrx, openAmount, payAmount, openAmount.subtract(payAmount));
            if (!psl.save(trxName)) {
                form2.setResultInfo("alert('" + Msg.translate((Ctx)wsc.ctx, (String)"SaveError") + " : " + Msg.translate((Ctx)wsc.ctx, (String)"C_PaySelectionLine_ID") + "');");
                return;
            }
            this.log.fine("C_Invoice_ID=" + invoiceId + ", PayAmt=" + payAmount);
        }
        form2.setResultInfo("startButton('C_PaySelection_CreatePayment', 0, 155, 426, " + paySelection.getC_PaySelection_ID() + ");");
    }
}

