/*
 * Decompiled with CFR 0.152.
 */
package com.jware.common.charts;

import com.jware.common.charts.BaseChart;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import org.jCharts.Chart;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.AxisChartDataSet;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.DataSeries;
import org.jCharts.chartData.interfaces.IAxisPlotDataSet;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.properties.AreaChartProperties;
import org.jCharts.properties.AxisProperties;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.ChartTypeProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.ChartType;

public class AxisCharts
extends BaseChart {
    public static final int width = 500;
    public static final int height = 300;

    private AxisChart getChart(AxisProperties axisProperties) throws ChartDataException {
        String[] xAxisLabels = new String[]{"1998", "1999", "2000", "2001", "2002", "2003", "2004"};
        String xAxisTitle = "Years";
        String yAxisTitle = "Problems";
        String title = "Micro$oft at Work";
        DataSeries dataSeries = new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, title);
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)AxisCharts.createAxisChartDataSet(ChartType.AREA, (ChartTypeProperties)new AreaChartProperties(), 200, 5000));
        ChartProperties chartProperties = new ChartProperties();
        LegendProperties legendProperties = new LegendProperties();
        AxisChart axisChart = new AxisChart((IDataSeries)dataSeries, chartProperties, axisProperties, legendProperties, 500, 300);
        return axisChart;
    }

    public void run() throws ChartDataException, PropertyException {
        this.rounding();
        this.userDefinedScale();
        this.numberOfItemsOnYAxis();
        this.gridLines();
        this.dollarSigns();
        this.commas();
        this.axisBackgroundPaint();
        this.axisTitles();
        this.zeroLine();
        this.scaleFont();
        this.tickMarks();
        this.verticalXAxisLabels();
    }

    private void rounding() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setYAxisRoundValuesToNearest(-2);
        super.exportImage((Chart)this.getChart(axisProperties), "axisRounding");
    }

    private void userDefinedScale() throws ChartDataException, PropertyException {
        AxisProperties axisProperties = new AxisProperties(-2000.0, 850.0);
        axisProperties.setYAxisRoundValuesToNearest(0);
        super.exportImage((Chart)this.getChart(axisProperties), "userDefinedScale");
    }

    private void numberOfItemsOnYAxis() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setYAxisNumItems(8);
        super.exportImage((Chart)this.getChart(axisProperties), "numberOfItemsOnYAxis");
    }

    private void gridLines() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setGridLineColor(0, (Paint)Color.red);
        axisProperties.setShowGridLine(1, 0);
        axisProperties.setShowGridLine(0, 2);
        double[][] data = new double[][]{{3444.0, 1506.3, 2777.0, 2550.345, 659.667, 950.6644, 4500.3453, 1200.67583, 3000.4354, 1268.0001, 2444.432, 5003.0}};
        String[] xAxisLabels = new String[]{"January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        String[] legendLabels = new String[]{"New Bugs in Windows Per Month"};
        Paint[] paints = new Paint[]{Color.blue};
        String xAxisTitle = "Months";
        String yAxisTitle = "Bugs";
        String title = "Micro$oft At Work";
        DataSeries dataSeries = new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, title);
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet((double[][])data, legendLabels, paints, ChartType.AREA, (ChartTypeProperties)new AreaChartProperties());
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
        AxisChart axisChart = new AxisChart((IDataSeries)dataSeries, new ChartProperties(), axisProperties, new LegendProperties(), 500, 300);
        super.exportImage((Chart)axisChart, "gridLines");
    }

    private void dollarSigns() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setYAxisUseDollarSigns(true);
        super.exportImage((Chart)this.getChart(axisProperties), "dollarSigns");
    }

    private void commas() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setYAxisUseCommas(false);
        super.exportImage((Chart)this.getChart(axisProperties), "commas");
    }

    private void axisBackgroundPaint() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setBackgroundPaint((Paint)Color.yellow);
        super.exportImage((Chart)this.getChart(axisProperties), "axisBackground");
    }

    private void axisTitles() throws ChartDataException {
        double[][] data = new double[][]{{3444.0, 1506.3, 2777.0, 2550.345, 659.667, 950.6644, 4500.3453, 1200.67583, 3000.4354, 1268.0001, 2444.432, 5003.0}};
        String[] xAxisLabels = new String[]{"January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
        String[] legendLabels = new String[]{"New Bugs in Windows Per Month"};
        Paint[] paints = new Paint[]{Color.blue};
        String xAxisTitle = "Months";
        String yAxisTitle = "Bugs";
        String title = "Micro$oft At Work";
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet((double[][])data, legendLabels, paints, ChartType.AREA, (ChartTypeProperties)new AreaChartProperties());
        DataSeries dataSeries = new DataSeries(xAxisLabels, null, yAxisTitle, title);
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
        AxisChart axisChart = new AxisChart((IDataSeries)dataSeries, new ChartProperties(), new AxisProperties(), new LegendProperties(), 500, 300);
        super.exportImage((Chart)axisChart, "axisTitles");
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setAxisTitleFont(new Font("Arial Narrow", 1, 14));
        axisProperties.setAxisTitleColor((Paint)Color.blue);
        axisChart = new AxisChart((IDataSeries)dataSeries, new ChartProperties(), axisProperties, new LegendProperties(), 500, 300);
        super.exportImage((Chart)axisChart, "axisTitleFont");
    }

    private void zeroLine() throws ChartDataException, PropertyException {
        AxisProperties axisProperties = new AxisProperties(-2000.0, 1200.0);
        axisProperties.setShowZeroLine(false);
        super.exportImage((Chart)this.getChart(axisProperties), "noZeroLine");
        axisProperties.setShowZeroLine(true);
        axisProperties.setZeroLinePaint((Paint)Color.red);
        axisProperties.setZeroLineStroke((Stroke)new BasicStroke(1.0f, 1, 1, 5.0f, new float[]{5.0f, 5.0f, 10.0f, 5.0f}, 4.0f));
        super.exportImage((Chart)this.getChart(axisProperties), "zeroLinePaintStroke");
    }

    private void scaleFont() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setScaleFont(new Font("Georgia Negreta cursiva", 0, 13));
        axisProperties.setScaleFontColor((Paint)Color.blue);
        super.exportImage((Chart)this.getChart(axisProperties), "scaleFont");
    }

    private void verticalXAxisLabels() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setXAxisVerticalScaleFlag(true);
        super.exportImage((Chart)this.getChart(axisProperties), "verticalXAxisLabels");
    }

    private void tickMarks() throws ChartDataException {
        AxisProperties axisProperties = new AxisProperties();
        axisProperties.setShowTicks(0, 2);
        super.exportImage((Chart)this.getChart(axisProperties), "ticksWithLabels");
        axisProperties = new AxisProperties();
        axisProperties.setShowTicks(0, 0);
        super.exportImage((Chart)this.getChart(axisProperties), "noTicks");
        axisProperties = new AxisProperties();
        axisProperties.setTickColor(0, (Paint)Color.blue);
        axisProperties.setTickColor(1, (Paint)Color.green);
        super.exportImage((Chart)this.getChart(axisProperties), "tickColors");
        axisProperties = new AxisProperties();
        axisProperties.setTickStroke(0, (Stroke)new BasicStroke(2.0f));
        super.exportImage((Chart)this.getChart(axisProperties), "tickStroke");
    }

    public static final DataSeries createDataSeries() {
        String[] xAxisLabels = new String[]{"1998", "1999", "2000", "2001", "2002", "2003", "2004"};
        String xAxisTitle = "Years";
        String yAxisTitle = "Problems";
        Object title = null;
        return new DataSeries(xAxisLabels, xAxisTitle, yAxisTitle, "Micro$oft At Work");
    }

    public static final AxisChartDataSet createAxisChartDataSet(ChartType chartType, ChartTypeProperties chartTypeProperties, int minValue, int maxValue) throws ChartDataException {
        double[][] data = TestDataGenerator.getRandomNumbers((int)3, (int)7, (double)minValue, (double)maxValue);
        String[] legendLabels = new String[]{"Bugs", "Security Holes", "Backdoors"};
        Paint[] paints = TestDataGenerator.getRandomPaints((int)3);
        return new AxisChartDataSet(data, legendLabels, paints, chartType, chartTypeProperties);
    }
}

