/*
 * Decompiled with CFR 0.152.
 */
package com.jware.util;

import com.jware.base.error.JwareApplicationException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.struts.upload.FormFile;

public class FileUploader {
    static final int BUFFER_SIZE = 2048;
    private FormFile formFile = null;
    private String fileName = null;
    private String contentType = null;
    private String size = null;
    private String distination = null;

    public FileUploader(FormFile file) {
        this.formFile = file;
    }

    public List executeWithZipExtract(String resourceBundle, String filePath, boolean extractFlg) throws JwareApplicationException {
        ArrayList<String> fileNames = null;
        if (this.fileName == null) {
            this.fileName = this.formFile.getFileName();
        }
        this.contentType = this.formFile.getContentType();
        this.size = Integer.toString(this.formFile.getFileSize());
        if (!extractFlg || !this.fileName.endsWith(".zip")) {
            this.distination = filePath + System.getProperty("file.separator") + this.fileName;
            fileNames = new ArrayList<String>(1);
            fileNames.add(this.fileName);
            try {
                InputStream stream = this.formFile.getInputStream();
                File pathFile = new File(filePath);
                if (!pathFile.exists()) {
                    pathFile.mkdirs();
                }
                FileOutputStream os = new FileOutputStream(this.distination);
                int bytesRead = 0;
                byte[] buffer = new byte[8192];
                while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                    ((OutputStream)os).write(buffer, 0, bytesRead);
                }
                ((OutputStream)os).close();
                stream.close();
            }
            catch (FileNotFoundException fnfe) {
                throw new JwareApplicationException("20000", fnfe);
            }
            catch (IOException ioe) {
                throw new JwareApplicationException("20000", ioe);
            }
        }
        try {
            InputStream stream = this.formFile.getInputStream();
            fileNames = this.unzip(stream, filePath);
            stream.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new JwareApplicationException("20000", fnfe);
        }
        catch (IOException ioe) {
            throw new JwareApplicationException("20000", ioe);
        }
        this.formFile.destroy();
        return fileNames;
    }

    public void execute(String resourceBundle, String filePath) throws JwareApplicationException {
        if (this.fileName == null) {
            this.fileName = this.formFile.getFileName();
        }
        this.contentType = this.formFile.getContentType();
        this.size = Integer.toString(this.formFile.getFileSize());
        this.distination = filePath + System.getProperty("file.separator") + this.fileName;
        try {
            InputStream stream = this.formFile.getInputStream();
            File pathFile = new File(filePath);
            if (!pathFile.exists()) {
                pathFile.mkdirs();
            }
            FileOutputStream os = new FileOutputStream(this.distination);
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            stream.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new JwareApplicationException("20000", fnfe);
        }
        catch (IOException ioe) {
            throw new JwareApplicationException("20000", ioe);
        }
        this.formFile.destroy();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getDistination() {
        return this.distination;
    }

    public String getFileName() {
        return this.fileName;
    }

    public FormFile getFormFile() {
        return this.formFile;
    }

    public String getSize() {
        return this.size;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFormFile(FormFile file) {
        this.formFile = file;
    }

    private ArrayList unzip(InputStream zipStream, String outbase) {
        File f = new File(outbase);
        if (!f.exists()) {
            f.mkdirs();
        }
        ArrayList<String> filenames = new ArrayList<String>();
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(zipStream));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                String en = entry.getName();
                if (en.endsWith("/")) continue;
                int indexDir = en.lastIndexOf("/");
                if (indexDir > 0) {
                    String dir = en.substring(0, indexDir);
                    File tempDir = new File(outbase + File.separator + dir);
                    if (!tempDir.exists()) {
                        tempDir.mkdirs();
                    }
                }
                en = outbase + File.separator + en;
                filenames.add(en);
                FileOutputStream fos = new FileOutputStream(en);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return filenames;
    }
}

